/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DataInputStreamLittleEndian
extends FilterInputStream {
    private DataInputStream dis = new DataInputStream(this);
    byte[] buf;

    public DataInputStreamLittleEndian(InputStream in) {
        super(in);
    }

    public DataInputStreamLittleEndian(URL url) throws IOException {
        super(new BufferedInputStream(url.openStream()));
    }

    final byte[] getBuf(int size) {
        if (this.buf == null || this.buf.length < size) {
            this.buf = new byte[size];
        }
        return this.buf;
    }

    public final int readInt() throws IOException {
        return Integer.reverseBytes(this.dis.readInt());
    }

    public final short readShort() throws IOException {
        return Short.reverseBytes(this.dis.readShort());
    }

    public final int readUnsignedShort() throws IOException {
        int shortValue;
        int intValue = shortValue = this.readShort();
        return intValue &= 0xFFFF;
    }

    public final int readUnsignedByte() throws IOException {
        int byteValue;
        int intValue = byteValue = this.readByte();
        return intValue &= 0xFF;
    }

    public final long readLong() throws IOException {
        return Long.reverseBytes(this.dis.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readString(int size) throws IOException {
        byte[] buf = this.getBuf(size);
        this.read(buf, 0, size);
        for (int i = 0; i < size; ++i) {
            if (buf[i] != 0) continue;
            return new String(buf, 0, i, "Shift_JIS").intern();
        }
        return new String(buf, "Shift_JIS");
    }

    public final byte readByte() throws IOException {
        byte[] buf = this.getBuf(1);
        this.read(buf, 0, 1);
        return buf[0];
    }
}

