package mygame;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import projectkyoto.jme3.mmd.CartoonEdgeProcessor;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.UpdateControl;
import projectkyoto.jme3.mmd.vmd.VMDControl;
import projectkyoto.mmd.file.VMDFile;

/**
 * test
 * <p/>
 * @author kobayasi
 */
public class Main extends SimpleApplication {

    PointLight pl;
    Geometry lightMdl;
    VMDControl vmdControl;

    public static void main(String[] args) {
//        com.jme3.system.JmeSystem.setLowPermissions(true);
        Main app = new Main();
        app.start();
    }

    @Override
    public void simpleInitApp() {
        flyCam.setMoveSpeed(50);
        // Load Model
        PMDNode pmdNode = (PMDNode) assetManager.loadModel("/Model/初音ミク.pmd");
        VMDFile vmd = (VMDFile) assetManager.loadAsset("/motion/ごまえミク.vmd");
        vmdControl = new VMDControl(pmdNode, vmd);
        pmdNode.addControl(vmdControl);
        pmdNode.addControl(new UpdateControl(pmdNode));
        vmdControl.setFrameNo(0);
        vmdControl.setPause(true);

        rootNode.attachChild(pmdNode);


        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1, 0, -5).normalizeLocal());
        dl.setColor(ColorRGBA.White.mult(0.5f));
        rootNode.addLight(dl);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(1.0f));
        rootNode.addLight(al);
        CartoonEdgeProcessor cartoonEdgeProcess = new CartoonEdgeProcessor();
        viewPort.addProcessor(cartoonEdgeProcess);

        cam.setLocation(new Vector3f(0, 10, 40));
    }
    float time = 0;

    @Override
    public void simpleUpdate(float tpf) {
        time += tpf;
        if (time > 5) {
            // start after 5 seconds.
            if (vmdControl != null) {
                vmdControl.setPause(false);
            }
        }
    }
}
