/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.renderer.lwjgl.render;

import de.lessvoid.nifty.renderer.lwjgl.render.io.ImageData;
import de.lessvoid.nifty.renderer.lwjgl.render.io.ImageIOImageData;
import de.lessvoid.nifty.renderer.lwjgl.render.io.TGAImageData;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.resourceloader.ResourceLoader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class LwjglRenderImage
implements RenderImage {
    private Logger log = Logger.getLogger(LwjglRenderImage.class.getName());
    private int width;
    private int height;
    private int textureWidth;
    private int textureHeight;
    private int textureId;

    public LwjglRenderImage(String name, boolean filterParam) {
        try {
            this.log.fine("loading image: " + name);
            ImageData imageLoader = name.endsWith(".tga") ? new TGAImageData() : new ImageIOImageData();
            ByteBuffer imageData = imageLoader.loadImage(ResourceLoader.getResourceAsStream((String)name));
            imageData.rewind();
            this.width = imageLoader.getWidth();
            this.height = imageLoader.getHeight();
            this.textureWidth = imageLoader.getTexWidth();
            this.textureHeight = imageLoader.getTexHeight();
            this.createTexture(imageData, this.textureWidth, this.textureHeight, 0, imageLoader.getDepth() == 32 ? 6408 : 6407);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public void dispose() {
    }

    private void createTexture(ByteBuffer textureBuffer, int width, int height, int filter, int srcPixelFormat) throws Exception {
        this.textureId = this.createTextureID();
        int minFilter = 9728;
        int magFilter = 9728;
        this.bind();
        int componentCount = 1;
        IntBuffer temp = BufferUtils.createIntBuffer((int)16);
        GL11.glGetInteger((int)3379, (IntBuffer)temp);
        this.checkGLError();
        int max = temp.get(0);
        if (width > max || height > max) {
            throw new Exception("Attempt to allocate a texture to big for the current hardware");
        }
        if (width < 0) {
            this.log.warning("Attempt to allocate a texture with negative width");
            return;
        }
        if (height < 0) {
            this.log.warning("Attempt to allocate a texture with negative height");
            return;
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        this.checkGLError();
        if (minFilter == 9985) {
            GLU.gluBuild2DMipmaps((int)3553, (int)componentCount, (int)width, (int)height, (int)srcPixelFormat, (int)5121, (ByteBuffer)textureBuffer);
        } else {
            GL11.glTexImage2D((int)3553, (int)0, (int)4, (int)width, (int)height, (int)0, (int)srcPixelFormat, (int)5121, (ByteBuffer)textureBuffer);
        }
        this.checkGLError();
    }

    private int createTextureID() {
        IntBuffer tmp = this.createIntBuffer(1);
        GL11.glGenTextures((IntBuffer)tmp);
        this.checkGLError();
        return tmp.get(0);
    }

    private IntBuffer createIntBuffer(int size) {
        ByteBuffer temp = ByteBuffer.allocateDirect(4 * size);
        temp.order(ByteOrder.nativeOrder());
        return temp.asIntBuffer();
    }

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.textureId);
        this.checkGLError();
    }

    private void checkGLError() {
        int error = GL11.glGetError();
        if (error != 0) {
            String glerrmsg = GLU.gluErrorString((int)error);
            this.log.warning("OpenGL Error: (" + error + ") " + glerrmsg);
        }
    }
}

