/*
 * Decompiled with CFR 0.152.
 */
package jme3test.awt;

import com.jme3.app.Application;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.system.JmeSystem;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;

public class AppHarness
extends Applet {
    private JmeCanvasContext context;
    private Canvas canvas;
    private Application app;
    private String appClass;
    private URL appCfg = null;

    private void createCanvas() {
        AppSettings settings = new AppSettings(true);
        if (this.appCfg != null) {
            try {
                InputStream in = this.appCfg.openStream();
                settings.load(in);
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        settings.setWidth(this.getWidth());
        settings.setHeight(this.getHeight());
        settings.setAudioRenderer(null);
        JmeSystem.setLowPermissions((boolean)true);
        try {
            Class<?> clazz = Class.forName(this.appClass);
            this.app = (Application)clazz.newInstance();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        this.app.setSettings(settings);
        this.app.createCanvas();
        this.context = (JmeCanvasContext)this.app.getContext();
        this.canvas = this.context.getCanvas();
        this.canvas.setSize(this.getWidth(), this.getHeight());
        this.add(this.canvas);
        this.app.startCanvas();
    }

    public final void update(Graphics g) {
        this.canvas.setSize(this.getWidth(), this.getHeight());
    }

    public void init() {
        this.appClass = this.getParameter("AppClass");
        if (this.appClass == null) {
            throw new RuntimeException("The required parameter AppClass isn't specified!");
        }
        try {
            this.appCfg = new URL(this.getParameter("AppSettingsURL"));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            this.appCfg = null;
        }
        this.createCanvas();
        System.out.println("applet:init");
    }

    public void start() {
        this.context.setAutoFlushFrames(true);
        System.out.println("applet:start");
    }

    public void stop() {
        this.context.setAutoFlushFrames(false);
        System.out.println("applet:stop");
    }

    public void destroy() {
        System.out.println("applet:destroyStart");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AppHarness.this.removeAll();
                System.out.println("applet:destroyRemoved");
            }
        });
        this.app.stop(true);
        System.out.println("applet:destroyDone");
    }
}

