/*
 * Decompiled with CFR 0.152.
 */
package jme3test.awt;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.util.JmeFormatter;
import java.awt.Canvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class TestCanvas {
    private static JmeCanvasContext context;
    private static Canvas canvas;
    private static Application app;
    private static JFrame frame;
    private static final String appClass = "jme3test.post.TestMultiplesFilters";

    private static void createFrame() {
        frame = new JFrame("Test");
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                app.stop();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu("File");
        menuBar.add(menuFile);
        final JMenuItem itemRemoveCanvas = new JMenuItem("Remove Canvas");
        menuFile.add(itemRemoveCanvas);
        itemRemoveCanvas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (itemRemoveCanvas.getText().equals("Remove Canvas")) {
                    frame.getContentPane().remove(canvas);
                    frame.setVisible(false);
                    frame.setVisible(true);
                    frame.requestFocus();
                    itemRemoveCanvas.setText("Add Canvas");
                } else if (itemRemoveCanvas.getText().equals("Add Canvas")) {
                    frame.getContentPane().add(canvas);
                    itemRemoveCanvas.setText("Remove Canvas");
                }
            }
        });
        JMenuItem itemKillCanvas = new JMenuItem("Stop/Start Canvas");
        menuFile.add(itemKillCanvas);
        itemKillCanvas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frame.getContentPane().remove(canvas);
                app.stop(true);
                TestCanvas.createCanvas(TestCanvas.appClass);
                frame.getContentPane().add(canvas);
                frame.pack();
                TestCanvas.startApp();
            }
        });
        JMenuItem itemExit = new JMenuItem("Exit");
        menuFile.add(itemExit);
        itemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                frame.dispose();
                app.stop();
            }
        });
        JMenu menuEdit = new JMenu("Edit");
        menuBar.add(menuEdit);
        JMenuItem itemDelete = new JMenuItem("Delete");
        menuEdit.add(itemDelete);
        JMenu menuView = new JMenu("View");
        menuBar.add(menuView);
        JMenuItem itemSetting = new JMenuItem("Settings");
        menuView.add(itemSetting);
        JMenu menuHelp = new JMenu("Help");
        menuBar.add(menuHelp);
    }

    public static void createCanvas(String appClass) {
        AppSettings settings = new AppSettings(true);
        settings.setWidth(Math.max(640, frame.getContentPane().getWidth()));
        settings.setHeight(Math.max(480, frame.getContentPane().getHeight()));
        try {
            Class<?> clazz = Class.forName(appClass);
            app = (Application)clazz.newInstance();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        app.setPauseOnLostFocus(false);
        app.setSettings(settings);
        app.createCanvas();
        context = (JmeCanvasContext)app.getContext();
        canvas = context.getCanvas();
        canvas.setSize(settings.getWidth(), settings.getHeight());
    }

    public static void startApp() {
        app.startCanvas();
        app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                if (app instanceof SimpleApplication) {
                    SimpleApplication simpleApp = (SimpleApplication)app;
                    simpleApp.getFlyByCamera().setDragToRotate(true);
                }
                return null;
            }
        });
    }

    public static void main(String[] args) {
        JmeFormatter formatter = new JmeFormatter();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter((Formatter)formatter);
        Logger.getLogger("").removeHandler(Logger.getLogger("").getHandlers()[0]);
        Logger.getLogger("").addHandler(consoleHandler);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                TestCanvas.createFrame();
                TestCanvas.createCanvas(TestCanvas.appClass);
                frame.getContentPane().add(canvas);
                frame.pack();
                TestCanvas.startApp();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

