/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Texture;

public class PhysicsTestHelper {
    public static void createPhysicsTestWorld(Node rootNode, AssetManager assetManager, PhysicsSpace space) {
        AmbientLight light = new AmbientLight();
        light.setColor(ColorRGBA.LightGray);
        rootNode.addLight((Light)light);
        Material material = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setTexture("ColorMap", assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Box floorBox = new Box(140.0f, 0.25f, 140.0f);
        Geometry floorGeometry = new Geometry("Floor", (Mesh)floorBox);
        floorGeometry.setMaterial(material);
        floorGeometry.setLocalTranslation(0.0f, -5.0f, 0.0f);
        floorGeometry.addControl((Control)new RigidBodyControl(0.0f));
        rootNode.attachChild((Spatial)floorGeometry);
        space.add((Object)floorGeometry);
        for (int i = 0; i < 12; ++i) {
            Box box = new Box(0.25f, 0.25f, 0.25f);
            Geometry boxGeometry = new Geometry("Box", (Mesh)box);
            boxGeometry.setMaterial(material);
            boxGeometry.setLocalTranslation((float)i, 5.0f, -3.0f);
            boxGeometry.addControl((Control)new RigidBodyControl(2.0f));
            rootNode.attachChild((Spatial)boxGeometry);
            space.add((Object)boxGeometry);
        }
        Sphere sphere = new Sphere(8, 8, 1.0f);
        Geometry sphereGeometry = new Geometry("Sphere", (Mesh)sphere);
        sphereGeometry.setMaterial(material);
        sphereGeometry.setLocalTranslation(4.0f, -4.0f, 2.0f);
        sphereGeometry.addControl((Control)new RigidBodyControl((CollisionShape)new MeshCollisionShape((Mesh)sphere), 0.0f));
        rootNode.attachChild((Spatial)sphereGeometry);
        space.add((Object)sphereGeometry);
    }

    public static void createPhysicsTestWorldSoccer(Node rootNode, AssetManager assetManager, PhysicsSpace space) {
        AmbientLight light = new AmbientLight();
        light.setColor(ColorRGBA.LightGray);
        rootNode.addLight((Light)light);
        Material material = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setTexture("ColorMap", assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Box floorBox = new Box(140.0f, 0.25f, 140.0f);
        Geometry floorGeometry = new Geometry("Floor", (Mesh)floorBox);
        floorGeometry.setMaterial(material);
        floorGeometry.setLocalTranslation(0.0f, -0.25f, 0.0f);
        floorGeometry.addControl((Control)new RigidBodyControl(0.0f));
        rootNode.attachChild((Spatial)floorGeometry);
        space.add((Object)floorGeometry);
        for (int i = 0; i < 5; ++i) {
            Sphere sphere = new Sphere(16, 16, 0.5f);
            Geometry ballGeometry = new Geometry("Soccer ball", (Mesh)sphere);
            ballGeometry.setMaterial(material);
            ballGeometry.setLocalTranslation((float)i, 2.0f, -3.0f);
            ballGeometry.addControl((Control)new RigidBodyControl(0.001f));
            ((RigidBodyControl)ballGeometry.getControl(RigidBodyControl.class)).setRestitution(1.0f);
            rootNode.attachChild((Spatial)ballGeometry);
            space.add((Object)ballGeometry);
        }
        Box box = new Box(1.0f, 1.0f, 1.0f);
        Geometry boxGeometry = new Geometry("Box", (Mesh)box);
        boxGeometry.setMaterial(material);
        boxGeometry.setLocalTranslation(4.0f, 1.0f, 2.0f);
        boxGeometry.addControl((Control)new RigidBodyControl((CollisionShape)new MeshCollisionShape((Mesh)box), 0.0f));
        rootNode.attachChild((Spatial)boxGeometry);
        space.add((Object)boxGeometry);
    }

    public static Geometry createPhysicsTestBox(AssetManager assetManager) {
        Material material = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setTexture("ColorMap", assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Box box = new Box(0.25f, 0.25f, 0.25f);
        Geometry boxGeometry = new Geometry("Box", (Mesh)box);
        boxGeometry.setMaterial(material);
        boxGeometry.addControl((Control)new RigidBodyControl(2.0f));
        return boxGeometry;
    }

    public static Geometry createPhysicsTestSphere(AssetManager assetManager) {
        Material material = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setTexture("ColorMap", assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Sphere sphere = new Sphere(8, 8, 0.25f);
        Geometry boxGeometry = new Geometry("Sphere", (Mesh)sphere);
        boxGeometry.setMaterial(material);
        boxGeometry.addControl((Control)new RigidBodyControl(2.0f));
        return boxGeometry;
    }

    public static Node createPhysicsTestNode(AssetManager manager, CollisionShape shape, float mass) {
        Node node = new Node("PhysicsNode");
        RigidBodyControl control = new RigidBodyControl(shape, mass);
        node.addControl((Control)control);
        return node;
    }

    public static void createBallShooter(final Application app, final Node rootNode, final PhysicsSpace space) {
        ActionListener actionListener = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                Sphere bullet = new Sphere(32, 32, 0.4f, true, false);
                bullet.setTextureMode(Sphere.TextureMode.Projected);
                Material mat2 = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
                TextureKey key2 = new TextureKey("Textures/Terrain/Rock/Rock.PNG");
                key2.setGenerateMips(true);
                Texture tex2 = app.getAssetManager().loadTexture(key2);
                mat2.setTexture("ColorMap", tex2);
                if (name.equals("shoot") && !keyPressed) {
                    Geometry bulletg = new Geometry("bullet", (Mesh)bullet);
                    bulletg.setMaterial(mat2);
                    bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                    bulletg.setLocalTranslation(app.getCamera().getLocation());
                    RigidBodyControl bulletControl = new RigidBodyControl(1.0f);
                    bulletg.addControl((Control)bulletControl);
                    bulletControl.setLinearVelocity(app.getCamera().getDirection().mult(25.0f));
                    bulletg.addControl((Control)bulletControl);
                    rootNode.attachChild((Spatial)bulletg);
                    space.add((Object)bulletControl);
                }
            }
        };
        app.getInputManager().addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        app.getInputManager().addListener((InputListener)actionListener, new String[]{"shoot"});
    }
}

