/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CylinderCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.PlaneCollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.HingeJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.math.Plane;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3test.bullet.PhysicsTestHelper;

public class TestPhysicsReadWrite
extends SimpleApplication {
    private BulletAppState bulletAppState;
    private Node physicsRootNode;

    public static void main(String[] args) {
        TestPhysicsReadWrite app = new TestPhysicsReadWrite();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        this.physicsRootNode = new Node("PhysicsRootNode");
        this.rootNode.attachChild((Spatial)this.physicsRootNode);
        Node physicsSphere = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new SphereCollisionShape(1.0f), 1.0f);
        ((RigidBodyControl)physicsSphere.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(3.0f, 6.0f, 0.0f));
        this.rootNode.attachChild((Spatial)physicsSphere);
        this.getPhysicsSpace().add((Object)physicsSphere);
        Node physicsSphere2 = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, ((RigidBodyControl)physicsSphere.getControl(RigidBodyControl.class)).getCollisionShape(), 1.0f);
        ((RigidBodyControl)physicsSphere2.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(4.0f, 8.0f, 0.0f));
        this.rootNode.attachChild((Spatial)physicsSphere2);
        this.getPhysicsSpace().add((Object)physicsSphere2);
        Node physicsBox = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new BoxCollisionShape(new Vector3f(1.0f, 1.0f, 1.0f)), 1.0f);
        ((RigidBodyControl)physicsBox.getControl(RigidBodyControl.class)).setFriction(0.1f);
        ((RigidBodyControl)physicsBox.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.6f, 4.0f, 0.5f));
        this.rootNode.attachChild((Spatial)physicsBox);
        this.getPhysicsSpace().add((Object)physicsBox);
        Node physicsCylinder = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new CylinderCollisionShape(new Vector3f(1.0f, 1.0f, 1.5f)), 1.0f);
        ((RigidBodyControl)physicsCylinder.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(2.0f, 2.0f, 0.0f));
        this.rootNode.attachChild((Spatial)physicsCylinder);
        this.getPhysicsSpace().add((Object)physicsCylinder);
        Node node2 = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new MeshCollisionShape((Mesh)new Sphere(16, 16, 1.2f)), 0.0f);
        ((RigidBodyControl)node2.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(2.5f, -4.0f, 0.0f));
        this.rootNode.attachChild((Spatial)node2);
        this.getPhysicsSpace().add((Object)node2);
        Node node3 = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new PlaneCollisionShape(new Plane(new Vector3f(0.0f, 1.0f, 0.0f), 0.0f)), 0.0f);
        ((RigidBodyControl)node3.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.0f, -6.0f, 0.0f));
        this.rootNode.attachChild((Spatial)node3);
        this.getPhysicsSpace().add((Object)node3);
        HingeJoint joint = new HingeJoint((PhysicsRigidBody)physicsSphere.getControl(RigidBodyControl.class), (PhysicsRigidBody)physicsBox.getControl(RigidBodyControl.class), new Vector3f(-2.0f, 0.0f, 0.0f), new Vector3f(2.0f, 0.0f, 0.0f), Vector3f.UNIT_Z, Vector3f.UNIT_Z);
        this.getPhysicsSpace().add((Object)joint);
        try {
            this.getPhysicsSpace().removeAll((Spatial)this.physicsRootNode);
            this.physicsRootNode.removeFromParent();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BinaryExporter.getInstance().save((Savable)this.physicsRootNode, (OutputStream)bout);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            BinaryImporter imp = BinaryImporter.getInstance();
            imp.setAssetManager(this.assetManager);
            Node newPhysicsRootNode = (Node)imp.load((InputStream)bin);
            this.getPhysicsSpace().addAll((Spatial)newPhysicsRootNode);
            this.rootNode.attachChild((Spatial)newPhysicsRootNode);
        }
        catch (IOException ex) {
            Logger.getLogger(TestPhysicsReadWrite.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void simpleUpdate(float tpf) {
    }

    public void simpleRender(RenderManager rm) {
    }
}

