/*
 * Decompiled with CFR 0.152.
 */
package jme3test.effect;

import com.jme3.app.SimpleApplication;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.effect.shapes.EmitterSphereShape;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;

public class TestExplosionEffect
extends SimpleApplication {
    private float time = 0.0f;
    private int state = 0;
    private Node explosionEffect = new Node("explosionFX");
    private ParticleEmitter flame;
    private ParticleEmitter flash;
    private ParticleEmitter spark;
    private ParticleEmitter roundspark;
    private ParticleEmitter smoketrail;
    private ParticleEmitter debris;
    private ParticleEmitter shockwave;
    private static final int COUNT_FACTOR = 1;
    private static final float COUNT_FACTOR_F = 1.0f;
    private static final boolean POINT_SPRITE = true;
    private static final ParticleMesh.Type EMITTER_TYPE = ParticleMesh.Type.Point;

    public static void main(String[] args) {
        TestExplosionEffect app = new TestExplosionEffect();
        app.start();
    }

    private void createFlame() {
        this.flame = new ParticleEmitter("Flame", EMITTER_TYPE, 32);
        this.flame.setSelectRandomImage(true);
        this.flame.setStartColor(new ColorRGBA(1.0f, 0.4f, 0.05f, 1.0f));
        this.flame.setEndColor(new ColorRGBA(0.4f, 0.22f, 0.12f, 0.0f));
        this.flame.setStartSize(1.3f);
        this.flame.setEndSize(2.0f);
        this.flame.setShape((EmitterShape)new EmitterSphereShape(Vector3f.ZERO, 1.0f));
        this.flame.setParticlesPerSec(0.0f);
        this.flame.setGravity(0.0f, -5.0f, 0.0f);
        this.flame.setLowLife(0.4f);
        this.flame.setHighLife(0.5f);
        this.flame.getParticleInfluencer().setInitialVelocity(new Vector3f(0.0f, 7.0f, 0.0f));
        this.flame.getParticleInfluencer().setVelocityVariation(1.0f);
        this.flame.setImagesX(2);
        this.flame.setImagesY(2);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/flame.png"));
        mat.setBoolean("PointSprite", true);
        this.flame.setMaterial(mat);
        this.explosionEffect.attachChild((Spatial)this.flame);
    }

    private void createFlash() {
        this.flash = new ParticleEmitter("Flash", EMITTER_TYPE, 24);
        this.flash.setSelectRandomImage(true);
        this.flash.setStartColor(new ColorRGBA(1.0f, 0.8f, 0.36f, 1.0f));
        this.flash.setEndColor(new ColorRGBA(1.0f, 0.8f, 0.36f, 0.0f));
        this.flash.setStartSize(0.1f);
        this.flash.setEndSize(3.0f);
        this.flash.setShape((EmitterShape)new EmitterSphereShape(Vector3f.ZERO, 0.05f));
        this.flash.setParticlesPerSec(0.0f);
        this.flash.setGravity(0.0f, 0.0f, 0.0f);
        this.flash.setLowLife(0.2f);
        this.flash.setHighLife(0.2f);
        this.flash.setInitialVelocity(new Vector3f(0.0f, 5.0f, 0.0f));
        this.flash.setVelocityVariation(1.0f);
        this.flash.setImagesX(2);
        this.flash.setImagesY(2);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/flash.png"));
        mat.setBoolean("PointSprite", true);
        this.flash.setMaterial(mat);
        this.explosionEffect.attachChild((Spatial)this.flash);
    }

    private void createRoundSpark() {
        this.roundspark = new ParticleEmitter("RoundSpark", EMITTER_TYPE, 20);
        this.roundspark.setStartColor(new ColorRGBA(1.0f, 0.29f, 0.34f, 1.0f));
        this.roundspark.setEndColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        this.roundspark.setStartSize(1.2f);
        this.roundspark.setEndSize(1.8f);
        this.roundspark.setShape((EmitterShape)new EmitterSphereShape(Vector3f.ZERO, 2.0f));
        this.roundspark.setParticlesPerSec(0.0f);
        this.roundspark.setGravity(0.0f, -0.5f, 0.0f);
        this.roundspark.setLowLife(1.8f);
        this.roundspark.setHighLife(2.0f);
        this.roundspark.setInitialVelocity(new Vector3f(0.0f, 3.0f, 0.0f));
        this.roundspark.setVelocityVariation(0.5f);
        this.roundspark.setImagesX(1);
        this.roundspark.setImagesY(1);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/roundspark.png"));
        mat.setBoolean("PointSprite", true);
        this.roundspark.setMaterial(mat);
        this.explosionEffect.attachChild((Spatial)this.roundspark);
    }

    private void createSpark() {
        this.spark = new ParticleEmitter("Spark", ParticleMesh.Type.Triangle, 30);
        this.spark.setStartColor(new ColorRGBA(1.0f, 0.8f, 0.36f, 1.0f));
        this.spark.setEndColor(new ColorRGBA(1.0f, 0.8f, 0.36f, 0.0f));
        this.spark.setStartSize(0.5f);
        this.spark.setEndSize(0.5f);
        this.spark.setFacingVelocity(true);
        this.spark.setParticlesPerSec(0.0f);
        this.spark.setGravity(0.0f, 5.0f, 0.0f);
        this.spark.setLowLife(1.1f);
        this.spark.setHighLife(1.5f);
        this.spark.getParticleInfluencer().setInitialVelocity(new Vector3f(0.0f, 20.0f, 0.0f));
        this.spark.getParticleInfluencer().setVelocityVariation(1.0f);
        this.spark.setImagesX(1);
        this.spark.setImagesY(1);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/spark.png"));
        this.spark.setMaterial(mat);
        this.explosionEffect.attachChild((Spatial)this.spark);
    }

    private void createSmokeTrail() {
        this.smoketrail = new ParticleEmitter("SmokeTrail", ParticleMesh.Type.Triangle, 22);
        this.smoketrail.setStartColor(new ColorRGBA(1.0f, 0.8f, 0.36f, 1.0f));
        this.smoketrail.setEndColor(new ColorRGBA(1.0f, 0.8f, 0.36f, 0.0f));
        this.smoketrail.setStartSize(0.2f);
        this.smoketrail.setEndSize(1.0f);
        this.smoketrail.setFacingVelocity(true);
        this.smoketrail.setParticlesPerSec(0.0f);
        this.smoketrail.setGravity(0.0f, 1.0f, 0.0f);
        this.smoketrail.setLowLife(0.4f);
        this.smoketrail.setHighLife(0.5f);
        this.smoketrail.setInitialVelocity(new Vector3f(0.0f, 12.0f, 0.0f));
        this.smoketrail.setVelocityVariation(1.0f);
        this.smoketrail.setImagesX(1);
        this.smoketrail.setImagesY(3);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/smoketrail.png"));
        this.smoketrail.setMaterial(mat);
        this.explosionEffect.attachChild((Spatial)this.smoketrail);
    }

    private void createDebris() {
        this.debris = new ParticleEmitter("Debris", ParticleMesh.Type.Triangle, 15);
        this.debris.setSelectRandomImage(true);
        this.debris.setRandomAngle(true);
        this.debris.setRotateSpeed((float)Math.PI * 8);
        this.debris.setStartColor(new ColorRGBA(1.0f, 0.59f, 0.28f, 1.0f));
        this.debris.setEndColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.0f));
        this.debris.setStartSize(0.2f);
        this.debris.setEndSize(0.2f);
        this.debris.setParticlesPerSec(0.0f);
        this.debris.setGravity(0.0f, 12.0f, 0.0f);
        this.debris.setLowLife(1.4f);
        this.debris.setHighLife(1.5f);
        this.debris.setInitialVelocity(new Vector3f(0.0f, 15.0f, 0.0f));
        this.debris.setVelocityVariation(0.6f);
        this.debris.setImagesX(3);
        this.debris.setImagesY(3);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/Debris.png"));
        this.debris.setMaterial(mat);
        this.explosionEffect.attachChild((Spatial)this.debris);
    }

    private void createShockwave() {
        this.shockwave = new ParticleEmitter("Shockwave", ParticleMesh.Type.Triangle, 1);
        this.shockwave.setFaceNormal(Vector3f.UNIT_Y);
        this.shockwave.setStartColor(new ColorRGBA(0.48f, 0.17f, 0.01f, 0.8f));
        this.shockwave.setEndColor(new ColorRGBA(0.48f, 0.17f, 0.01f, 0.0f));
        this.shockwave.setStartSize(0.0f);
        this.shockwave.setEndSize(7.0f);
        this.shockwave.setParticlesPerSec(0.0f);
        this.shockwave.setGravity(0.0f, 0.0f, 0.0f);
        this.shockwave.setLowLife(0.5f);
        this.shockwave.setHighLife(0.5f);
        this.shockwave.setInitialVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
        this.shockwave.setVelocityVariation(0.0f);
        this.shockwave.setImagesX(1);
        this.shockwave.setImagesY(1);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/shockwave.png"));
        this.shockwave.setMaterial(mat);
        this.explosionEffect.attachChild((Spatial)this.shockwave);
    }

    public void simpleInitApp() {
        this.createFlame();
        this.createFlash();
        this.createSpark();
        this.createRoundSpark();
        this.createSmokeTrail();
        this.createDebris();
        this.createShockwave();
        this.explosionEffect.setLocalScale(0.5f);
        this.renderManager.preloadScene((Spatial)this.explosionEffect);
        this.cam.setLocation(new Vector3f(0.0f, 3.5135868f, 10.0f));
        this.cam.setRotation(new Quaternion(1.5714673E-4f, 0.98696727f, -0.16091813f, 9.6381607E-4f));
        this.rootNode.attachChild((Spatial)this.explosionEffect);
    }

    public void simpleUpdate(float tpf) {
        this.time += tpf / this.speed;
        if (this.time > 1.0f && this.state == 0) {
            this.flash.emitAllParticles();
            this.spark.emitAllParticles();
            this.smoketrail.emitAllParticles();
            this.debris.emitAllParticles();
            this.shockwave.emitAllParticles();
            ++this.state;
        }
        if (this.time > 1.0f + 0.05f / this.speed && this.state == 1) {
            this.flame.emitAllParticles();
            this.roundspark.emitAllParticles();
            ++this.state;
        }
        if (this.time > 5.0f / this.speed && this.state == 2) {
            this.state = 0;
            this.time = 0.0f;
            this.flash.killAllParticles();
            this.spark.killAllParticles();
            this.smoketrail.killAllParticles();
            this.debris.killAllParticles();
            this.flame.killAllParticles();
            this.roundspark.killAllParticles();
            this.shockwave.killAllParticles();
        }
    }
}

