/*
 * Decompiled with CFR 0.152.
 */
package jme3test.input;

import com.jme3.app.SimpleApplication;
import com.jme3.input.Joystick;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.JoyAxisTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.system.AppSettings;

public class TestJoystick
extends SimpleApplication
implements AnalogListener {
    public static void main(String[] args) {
        TestJoystick app = new TestJoystick();
        AppSettings settings = new AppSettings(true);
        settings.setUseJoysticks(true);
        app.setSettings(settings);
        app.start();
    }

    public void simpleInitApp() {
        Joystick[] joysticks = this.inputManager.getJoysticks();
        if (joysticks == null) {
            throw new IllegalStateException("Cannot find any joysticks!");
        }
        for (Joystick joy : joysticks) {
            System.out.println(joy.toString());
        }
        this.inputManager.addMapping("DPAD Left", new Trigger[]{new JoyAxisTrigger(0, 254, true)});
        this.inputManager.addMapping("DPAD Right", new Trigger[]{new JoyAxisTrigger(0, 254, false)});
        this.inputManager.addMapping("DPAD Down", new Trigger[]{new JoyAxisTrigger(0, 255, true)});
        this.inputManager.addMapping("DPAD Up", new Trigger[]{new JoyAxisTrigger(0, 255, false)});
        this.inputManager.addListener((InputListener)this, new String[]{"DPAD Left", "DPAD Right", "DPAD Down", "DPAD Up"});
        this.inputManager.addMapping("Joy Left", new Trigger[]{new JoyAxisTrigger(0, 0, true)});
        this.inputManager.addMapping("Joy Right", new Trigger[]{new JoyAxisTrigger(0, 0, false)});
        this.inputManager.addMapping("Joy Down", new Trigger[]{new JoyAxisTrigger(0, 1, true)});
        this.inputManager.addMapping("Joy Up", new Trigger[]{new JoyAxisTrigger(0, 1, false)});
        this.inputManager.addListener((InputListener)this, new String[]{"Joy Left", "Joy Right", "Joy Down", "Joy Up"});
    }

    public void onAnalog(String name, float isPressed, float tpf) {
        System.out.println(name + " = " + isPressed);
    }

    public void onAction(String name, boolean isPressed, float tpf) {
        System.out.println(name + " = " + isPressed);
    }
}

