/*
 * Decompiled with CFR 0.152.
 */
package jme3test.input.combomoves;

import java.util.ArrayList;
import java.util.List;

public class ComboMove {
    private String moveName;
    private List<ComboMoveState> states = new ArrayList<ComboMoveState>();
    private boolean useFinalState = true;
    private float priority = 1.0f;
    private float castTime = 0.8f;
    private transient String[] pressed;
    private transient String[] unpressed;
    private transient float timeElapsed;

    public ComboMove(String moveName) {
        this.moveName = moveName;
    }

    public float getPriority() {
        return this.priority;
    }

    public void setPriority(float priority) {
        this.priority = priority;
    }

    public float getCastTime() {
        return this.castTime;
    }

    public void setCastTime(float castTime) {
        this.castTime = castTime;
    }

    public boolean useFinalState() {
        return this.useFinalState;
    }

    public void setUseFinalState(boolean useFinalState) {
        this.useFinalState = useFinalState;
    }

    public ComboMove press(String ... pressedMappings) {
        this.pressed = pressedMappings;
        return this;
    }

    public ComboMove notPress(String ... unpressedMappings) {
        this.unpressed = unpressedMappings;
        return this;
    }

    public ComboMove timeElapsed(float time) {
        this.timeElapsed = time;
        return this;
    }

    public void done() {
        if (this.pressed == null) {
            this.pressed = new String[0];
        }
        if (this.unpressed == null) {
            this.unpressed = new String[0];
        }
        this.states.add(new ComboMoveState(this.pressed, this.unpressed, this.timeElapsed));
        this.pressed = null;
        this.unpressed = null;
        this.timeElapsed = -1.0f;
    }

    public ComboMoveState getState(int num) {
        return this.states.get(num);
    }

    public int getNumStates() {
        return this.states.size();
    }

    public String getMoveName() {
        return this.moveName;
    }

    public static class ComboMoveState {
        private String[] pressedMappings;
        private String[] unpressedMappings;
        private float timeElapsed;

        public ComboMoveState(String[] pressedMappings, String[] unpressedMappings, float timeElapsed) {
            this.pressedMappings = pressedMappings;
            this.unpressedMappings = unpressedMappings;
            this.timeElapsed = timeElapsed;
        }

        public String[] getUnpressedMappings() {
            return this.unpressedMappings;
        }

        public String[] getPressedMappings() {
            return this.pressedMappings;
        }

        public float getTimeElapsed() {
            return this.timeElapsed;
        }
    }
}

