/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.LightNode;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.scene.shape.Torus;

public class TestLightNode
extends SimpleApplication {
    float angle;
    Node movingNode;

    public static void main(String[] args) {
        TestLightNode app = new TestLightNode();
        app.start();
    }

    public void simpleInitApp() {
        Torus torus = new Torus(10, 6, 1.0f, 3.0f);
        Geometry g = new Geometry("Torus Geom", (Mesh)torus);
        g.rotate(-1.5707964f, 0.0f, 0.0f);
        g.center();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 32.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setColor("Ambient", ColorRGBA.Black);
        mat.setColor("Diffuse", ColorRGBA.White);
        mat.setColor("Specular", ColorRGBA.White);
        g.setMaterial(mat);
        this.rootNode.attachChild((Spatial)g);
        Geometry lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.movingNode = new Node("lightParentNode");
        this.movingNode.attachChild((Spatial)lightMdl);
        this.rootNode.attachChild((Spatial)this.movingNode);
        PointLight pl = new PointLight();
        pl.setColor(ColorRGBA.Green);
        pl.setRadius(4.0f);
        this.rootNode.addLight((Light)pl);
        LightNode lightNode = new LightNode("pointLight", (Light)pl);
        this.movingNode.attachChild((Spatial)lightNode);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.Red);
        dl.setDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        this.rootNode.addLight((Light)dl);
    }

    public void simpleUpdate(float tpf) {
        this.angle += tpf;
        this.angle %= (float)Math.PI * 2;
        this.movingNode.setLocalTranslation(new Vector3f(FastMath.cos((float)this.angle) * 3.0f, 2.0f, FastMath.sin((float)this.angle) * 3.0f));
    }
}

