/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.scene.shape.Torus;

public class TestLightRadius
extends SimpleApplication {
    float pos;
    float vel = 1.0f;
    PointLight pl;
    Geometry lightMdl;

    public static void main(String[] args) {
        TestLightRadius app = new TestLightRadius();
        app.start();
    }

    public void simpleInitApp() {
        Torus torus = new Torus(10, 6, 1.0f, 3.0f);
        Geometry g = new Geometry("Torus Geom", (Mesh)torus);
        g.rotate(-1.5707964f, 0.0f, 0.0f);
        g.center();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 32.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setColor("Ambient", ColorRGBA.Black);
        mat.setColor("Diffuse", ColorRGBA.White);
        mat.setColor("Specular", ColorRGBA.White);
        g.setMaterial(mat);
        this.rootNode.attachChild((Spatial)g);
        this.lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.rootNode.attachChild((Spatial)this.lightMdl);
        this.pl = new PointLight();
        this.pl.setColor(ColorRGBA.Green);
        this.pl.setRadius(4.0f);
        this.rootNode.addLight((Light)this.pl);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.Red);
        dl.setDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        this.rootNode.addLight((Light)dl);
    }

    public void simpleUpdate(float tpf) {
        this.pos += tpf * this.vel * 5.0f;
        if (this.pos > 15.0f) {
            this.vel *= -1.0f;
        } else if (this.pos < -15.0f) {
            this.vel *= -1.0f;
        }
        this.pl.setPosition(new Vector3f(this.pos, 2.0f, 0.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
    }
}

