/*
 * Decompiled with CFR 0.152.
 */
package jme3test.model.anim;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Bone;
import com.jme3.animation.LoopMode;
import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.SkeletonDebugger;

public class TestOgreComplexAnim
extends SimpleApplication {
    private AnimControl control;
    private float angle = 0.0f;
    private float scale = 1.0f;
    private float rate = 1.0f;

    public static void main(String[] args) {
        TestOgreComplexAnim app = new TestOgreComplexAnim();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        this.cam.setLocation(new Vector3f(6.4013605f, 7.488437f, 12.843031f));
        this.cam.setRotation(new Quaternion(-0.060740203f, 0.93925786f, -0.2398315f, -0.2378785f));
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.1f, -0.7f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.rootNode.addLight((Light)dl);
        Node model = (Node)this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        this.control = (AnimControl)model.getControl(AnimControl.class);
        AnimChannel feet = this.control.createChannel();
        AnimChannel leftHand = this.control.createChannel();
        AnimChannel rightHand = this.control.createChannel();
        feet.addFromRootBone("hip.right");
        feet.addFromRootBone("hip.left");
        feet.setAnim("Dodge");
        feet.setSpeed(2.0f);
        feet.setLoopMode(LoopMode.Cycle);
        feet.setAnim("Walk", 15.0f);
        feet.setSpeed(0.25f);
        feet.setLoopMode(LoopMode.Cycle);
        leftHand.addFromRootBone("uparm.right");
        leftHand.setAnim("pull");
        leftHand.setSpeed(0.5f);
        leftHand.setAnim("stand", 15.0f);
        rightHand.addBone("spinehigh");
        rightHand.addFromRootBone("uparm.left");
        rightHand.setAnim("push");
        SkeletonDebugger skeletonDebug = new SkeletonDebugger("skeleton", this.control.getSkeleton());
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", ColorRGBA.Green);
        mat.getAdditionalRenderState().setDepthTest(false);
        skeletonDebug.setMaterial(mat);
        model.attachChild((Spatial)skeletonDebug);
        this.rootNode.attachChild((Spatial)model);
    }

    public void simpleUpdate(float tpf) {
        Bone b = this.control.getSkeleton().getBone("spinehigh");
        Bone b2 = this.control.getSkeleton().getBone("uparm.left");
        this.angle += tpf * this.rate;
        if (this.angle > 0.7853982f) {
            this.angle = 0.7853982f;
            this.rate = -1.0f;
        } else if (this.angle < -0.7853982f) {
            this.angle = -0.7853982f;
            this.rate = 1.0f;
        }
        Quaternion q = new Quaternion();
        q.fromAngles(0.0f, this.angle, 0.0f);
        b.setUserControl(true);
        b.setUserTransforms(Vector3f.ZERO, q, Vector3f.UNIT_XYZ);
        b2.setUserControl(true);
        b2.setUserTransforms(Vector3f.ZERO, Quaternion.IDENTITY, new Vector3f(1.0f + this.angle, 1.0f + this.angle, 1.0f + this.angle));
    }
}

