/*
 * Decompiled with CFR 0.152.
 */
package jme3test.model.shape;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.debug.Grid;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.debug.WireSphere;

public class TestDebugShapes
extends SimpleApplication {
    public static void main(String[] args) {
        TestDebugShapes app = new TestDebugShapes();
        app.start();
    }

    public Geometry putShape(Mesh shape, ColorRGBA color) {
        Geometry g = new Geometry("shape", shape);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        this.rootNode.attachChild((Spatial)g);
        return g;
    }

    public void putArrow(Vector3f pos, Vector3f dir, ColorRGBA color) {
        Arrow arrow = new Arrow(dir);
        arrow.setLineWidth(4.0f);
        this.putShape((Mesh)arrow, color).setLocalTranslation(pos);
    }

    public void putBox(Vector3f pos, float size, ColorRGBA color) {
        this.putShape((Mesh)new WireBox(size, size, size), color).setLocalTranslation(pos);
    }

    public void putGrid(Vector3f pos, ColorRGBA color) {
        this.putShape((Mesh)new Grid(6, 6, 0.2f), color).center().move(pos);
    }

    public void putSphere(Vector3f pos, ColorRGBA color) {
        this.putShape((Mesh)new WireSphere(1.0f), color).setLocalTranslation(pos);
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(2.0f, 1.5f, 2.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        this.putArrow(Vector3f.ZERO, Vector3f.UNIT_X, ColorRGBA.Red);
        this.putArrow(Vector3f.ZERO, Vector3f.UNIT_Y, ColorRGBA.Green);
        this.putArrow(Vector3f.ZERO, Vector3f.UNIT_Z, ColorRGBA.Blue);
        this.putBox(new Vector3f(2.0f, 0.0f, 0.0f), 0.5f, ColorRGBA.Yellow);
        this.putGrid(new Vector3f(3.5f, 0.0f, 0.0f), ColorRGBA.White);
        this.putSphere(new Vector3f(4.5f, 0.0f, 0.0f), ColorRGBA.Magenta);
    }
}

