/*
 * Decompiled with CFR 0.152.
 */
package jme3test.terrain;

import com.jme3.app.SimpleApplication;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import java.awt.Image;
import jme3tools.converters.ImageToAwt;

public class TerrainTest
extends SimpleApplication {
    private TerrainQuad terrain;
    Material matRock;
    Material matWire;
    boolean wireframe = false;
    boolean triPlanar = false;
    protected BitmapText hintText;
    PointLight pl;
    Geometry lightMdl;
    private float grassScale = 64.0f;
    private float dirtScale = 16.0f;
    private float rockScale = 128.0f;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean pressed, float tpf) {
            if (name.equals("wireframe") && !pressed) {
                boolean bl = TerrainTest.this.wireframe = !TerrainTest.this.wireframe;
                if (!TerrainTest.this.wireframe) {
                    TerrainTest.this.terrain.setMaterial(TerrainTest.this.matWire);
                } else {
                    TerrainTest.this.terrain.setMaterial(TerrainTest.this.matRock);
                }
            } else if (name.equals("triPlanar") && !pressed) {
                boolean bl = TerrainTest.this.triPlanar = !TerrainTest.this.triPlanar;
                if (TerrainTest.this.triPlanar) {
                    TerrainTest.this.matRock.setBoolean("useTriPlanarMapping", true);
                    TerrainTest.this.matRock.setFloat("Tex1Scale", 1.0f / (512.0f / TerrainTest.this.grassScale));
                    TerrainTest.this.matRock.setFloat("Tex2Scale", 1.0f / (512.0f / TerrainTest.this.dirtScale));
                    TerrainTest.this.matRock.setFloat("Tex3Scale", 1.0f / (512.0f / TerrainTest.this.rockScale));
                } else {
                    TerrainTest.this.matRock.setBoolean("useTriPlanarMapping", false);
                    TerrainTest.this.matRock.setFloat("Tex1Scale", TerrainTest.this.grassScale);
                    TerrainTest.this.matRock.setFloat("Tex2Scale", TerrainTest.this.dirtScale);
                    TerrainTest.this.matRock.setFloat("Tex3Scale", TerrainTest.this.rockScale);
                }
            }
        }
    };

    public static void main(String[] args) {
        TerrainTest app = new TerrainTest();
        app.start();
    }

    public void initialize() {
        super.initialize();
        this.loadHintText();
    }

    public void simpleInitApp() {
        this.setupKeys();
        this.matRock = new Material(this.assetManager, "Common/MatDefs/Terrain/Terrain.j3md");
        this.matRock.setBoolean("useTriPlanarMapping", false);
        this.matRock.setTexture("Alpha", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("Tex1", grass);
        this.matRock.setFloat("Tex1Scale", this.grassScale);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("Tex2", dirt);
        this.matRock.setFloat("Tex2Scale", this.dirtScale);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("Tex3", rock);
        this.matRock.setFloat("Tex3Scale", this.rockScale);
        this.matWire = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matWire.getAdditionalRenderState().setWireframe(true);
        this.matWire.setColor("Color", ColorRGBA.Green);
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap((Image)ImageToAwt.convert((com.jme3.texture.Image)heightMapImage.getImage(), (boolean)false, (boolean)true, (int)0), 1.0f);
            heightmap.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain = new TerrainQuad("terrain", 65, 513, heightmap.getHeightMap());
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, this.getCamera());
        this.terrain.addControl((Control)control);
        this.terrain.setMaterial(this.matRock);
        this.terrain.setLocalTranslation(0.0f, -100.0f, 0.0f);
        this.terrain.setLocalScale(2.0f, 1.0f, 2.0f);
        this.rootNode.attachChild((Spatial)this.terrain);
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(-0.5f, -1.0f, -0.5f).normalize());
        this.rootNode.addLight((Light)light);
        this.cam.setLocation(new Vector3f(0.0f, 10.0f, -10.0f));
        this.cam.lookAtDirection(new Vector3f(0.0f, -1.5f, -1.0f).normalizeLocal(), Vector3f.UNIT_Y);
    }

    public void loadHintText() {
        this.hintText = new BitmapText(this.guiFont, false);
        this.hintText.setSize((float)this.guiFont.getCharSet().getRenderedSize());
        this.hintText.setLocalTranslation(0.0f, (float)this.getCamera().getHeight(), 0.0f);
        this.hintText.setText("Hit T to switch to wireframe,  P to switch to tri-planar texturing");
        this.guiNode.attachChild((Spatial)this.hintText);
    }

    private void setupKeys() {
        this.flyCam.setMoveSpeed(50.0f);
        this.inputManager.addMapping("wireframe", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"wireframe"});
        this.inputManager.addMapping("triPlanar", new Trigger[]{new KeyTrigger(25)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"triPlanar"});
    }
}

