/*
 * Decompiled with CFR 0.152.
 */
package jme3game.cubefield;

import com.jme3.app.SimpleApplication;
import com.jme3.bounding.BoundingVolume;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Dome;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CubeField
extends SimpleApplication
implements AnalogListener {
    private BitmapFont defaultFont;
    private boolean START;
    private int difficulty;
    private int Score;
    private int colorInt;
    private int highCap;
    private int lowCap;
    private int diffHelp;
    private Node player;
    private Geometry fcube;
    private ArrayList<Geometry> cubeField;
    private ArrayList<ColorRGBA> obstacleColors;
    private float speed;
    private float coreTime;
    private float coreTime2;
    private float camAngle = 0.0f;
    private BitmapText fpsScoreText;
    private BitmapText pressStart;
    private boolean solidBox = true;
    private Material playerMaterial;
    private Material floorMaterial;
    private float fpsRate = 1000.0f;

    public static void main(String[] args) {
        CubeField app = new CubeField();
        app.start();
    }

    public void simpleInitApp() {
        Logger.getLogger("com.jme3").setLevel(Level.WARNING);
        this.flyCam.setEnabled(false);
        this.statsView.setCullHint(Spatial.CullHint.Always);
        this.Keys();
        this.defaultFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        this.pressStart = new BitmapText(this.defaultFont, false);
        this.fpsScoreText = new BitmapText(this.defaultFont, false);
        this.loadText(this.fpsScoreText, "Current Score: 0", this.defaultFont, 0.0f, 2.0f, 0.0f);
        this.loadText(this.pressStart, "PRESS ENTER", this.defaultFont, 0.0f, 5.0f, 0.0f);
        this.player = this.createPlayer();
        this.rootNode.attachChild((Spatial)this.player);
        this.cubeField = new ArrayList();
        this.obstacleColors = new ArrayList();
        this.gameReset();
    }

    private void gameReset() {
        this.Score = 0;
        this.lowCap = 10;
        this.colorInt = 0;
        this.difficulty = this.highCap = 40;
        for (Geometry cube : this.cubeField) {
            cube.removeFromParent();
        }
        this.cubeField.clear();
        if (this.fcube != null) {
            this.fcube.removeFromParent();
        }
        this.fcube = this.createFirstCube();
        this.obstacleColors.clear();
        this.obstacleColors.add(ColorRGBA.Orange);
        this.obstacleColors.add(ColorRGBA.Red);
        this.obstacleColors.add(ColorRGBA.Yellow);
        this.renderer.setBackgroundColor(ColorRGBA.White);
        this.speed = (float)this.lowCap / 400.0f;
        this.coreTime = 20.0f;
        this.coreTime2 = 10.0f;
        this.diffHelp = this.lowCap;
        this.player.setLocalTranslation(0.0f, 0.0f, 0.0f);
    }

    public void simpleUpdate(float tpf) {
        this.camTakeOver(tpf);
        if (this.START) {
            this.gameLogic(tpf);
        }
        this.colorLogic();
    }

    private void camTakeOver(float tpf) {
        this.cam.setLocation(this.player.getLocalTranslation().add(-8.0f, 2.0f, 0.0f));
        this.cam.lookAt(this.player.getLocalTranslation(), Vector3f.UNIT_Y);
        Quaternion rot = new Quaternion();
        rot.fromAngleNormalAxis(this.camAngle, Vector3f.UNIT_Z);
        this.cam.setRotation(this.cam.getRotation().mult(rot));
        this.camAngle *= FastMath.pow((float)0.99f, (float)(this.fpsRate * tpf));
    }

    public void requestClose(boolean esc) {
        if (!esc) {
            System.out.println("The game was quit.");
        } else {
            System.out.println("Player has Collided. Final Score is " + this.Score);
        }
        this.context.destroy(false);
    }

    private void randomizeCube() {
        Geometry cube = this.fcube.clone();
        int playerX = (int)this.player.getLocalTranslation().getX();
        int playerZ = (int)this.player.getLocalTranslation().getZ();
        float x = FastMath.nextRandomInt((int)(playerX + this.difficulty + 30), (int)(playerX + this.difficulty + 90));
        float z = FastMath.nextRandomInt((int)(playerZ - this.difficulty - 50), (int)(playerZ + this.difficulty + 50));
        cube.getLocalTranslation().set(x, 0.0f, z);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        if (!this.solidBox) {
            mat.getAdditionalRenderState().setWireframe(true);
        }
        mat.setColor("Color", this.obstacleColors.get(FastMath.nextRandomInt((int)0, (int)(this.obstacleColors.size() - 1))));
        cube.setMaterial(mat);
        this.rootNode.attachChild((Spatial)cube);
        this.cubeField.add(cube);
    }

    private Geometry createFirstCube() {
        Vector3f loc = this.player.getLocalTranslation();
        loc.addLocal(4.0f, 0.0f, 0.0f);
        Box b = new Box(loc, 1.0f, 1.0f, 1.0f);
        Geometry geom = new Geometry("Box", (Mesh)b);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Blue);
        geom.setMaterial(mat);
        return geom;
    }

    private Node createPlayer() {
        Dome b = new Dome(Vector3f.ZERO, 10, 100, 1.0f);
        Geometry playerMesh = new Geometry("Box", (Mesh)b);
        this.playerMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.playerMaterial.setColor("Color", ColorRGBA.Red);
        playerMesh.setMaterial(this.playerMaterial);
        playerMesh.setName("player");
        Box floor = new Box(Vector3f.ZERO.add(playerMesh.getLocalTranslation().getX(), playerMesh.getLocalTranslation().getY() - 1.0f, 0.0f), 100.0f, 0.0f, 100.0f);
        Geometry floorMesh = new Geometry("Box", (Mesh)floor);
        this.floorMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.floorMaterial.setColor("Color", ColorRGBA.LightGray);
        floorMesh.setMaterial(this.floorMaterial);
        floorMesh.setName("floor");
        Node playerNode = new Node();
        playerNode.attachChild((Spatial)playerMesh);
        playerNode.attachChild((Spatial)floorMesh);
        return playerNode;
    }

    private void gameLost() {
        this.START = false;
        this.loadText(this.pressStart, "You lost! Press enter to try again.", this.defaultFont, 0.0f, 5.0f, 0.0f);
        this.gameReset();
    }

    private void gameLogic(float tpf) {
        if (this.timer.getTimeInSeconds() >= this.coreTime2) {
            this.coreTime2 = this.timer.getTimeInSeconds() + 10.0f;
            if (this.difficulty <= this.lowCap) {
                this.difficulty = this.lowCap;
            } else if (this.difficulty > this.lowCap) {
                this.difficulty -= 5;
                ++this.diffHelp;
            }
        }
        if (this.speed < 0.1f) {
            this.speed += 1.0E-6f * tpf * this.fpsRate;
        }
        this.player.move(this.speed * tpf * this.fpsRate, 0.0f, 0.0f);
        if (this.cubeField.size() > this.difficulty) {
            this.cubeField.remove(0);
        } else if (this.cubeField.size() != this.difficulty) {
            this.randomizeCube();
        }
        if (this.cubeField.isEmpty()) {
            this.requestClose(false);
        } else {
            for (int i = 0; i < this.cubeField.size(); ++i) {
                Geometry playerModel = (Geometry)this.player.getChild(0);
                Geometry cubeModel = this.cubeField.get(i);
                cubeModel.updateGeometricState();
                BoundingVolume pVol = playerModel.getWorldBound();
                BoundingVolume vVol = cubeModel.getWorldBound();
                if (pVol.intersects(vVol)) {
                    this.gameLost();
                    return;
                }
                if (!(this.cubeField.get(i).getLocalTranslation().getX() + 10.0f < this.player.getLocalTranslation().getX())) continue;
                this.cubeField.get(i).removeFromParent();
                this.cubeField.remove(this.cubeField.get(i));
            }
        }
        this.Score = (int)((float)this.Score + this.fpsRate * tpf);
        this.fpsScoreText.setText("Current Score: " + this.Score);
    }

    private void Keys() {
        this.inputManager.addMapping("START", new Trigger[]{new KeyTrigger(28)});
        this.inputManager.addMapping("Left", new Trigger[]{new KeyTrigger(203)});
        this.inputManager.addMapping("Right", new Trigger[]{new KeyTrigger(205)});
        this.inputManager.addListener((InputListener)this, new String[]{"START", "Left", "Right"});
    }

    public void onAnalog(String binding, float value, float tpf) {
        if (binding.equals("START") && !this.START) {
            this.START = true;
            this.guiNode.detachChild((Spatial)this.pressStart);
            System.out.println("START");
        } else if (this.START && binding.equals("Left")) {
            this.player.move(0.0f, 0.0f, -(this.speed / 2.0f) * value * this.fpsRate);
            this.camAngle -= value * tpf;
        } else if (this.START && binding.equals("Right")) {
            this.player.move(0.0f, 0.0f, this.speed / 2.0f * value * this.fpsRate);
            this.camAngle += value * tpf;
        }
    }

    private void colorLogic() {
        if (this.timer.getTimeInSeconds() >= this.coreTime) {
            ++this.colorInt;
            this.coreTime = this.timer.getTimeInSeconds() + 20.0f;
            switch (this.colorInt) {
                case 1: {
                    this.obstacleColors.clear();
                    this.solidBox = false;
                    this.obstacleColors.add(ColorRGBA.Green);
                    this.renderer.setBackgroundColor(ColorRGBA.Black);
                    this.playerMaterial.setColor("Color", ColorRGBA.White);
                    this.floorMaterial.setColor("Color", ColorRGBA.Black);
                    break;
                }
                case 2: {
                    this.obstacleColors.set(0, ColorRGBA.Black);
                    this.solidBox = true;
                    this.renderer.setBackgroundColor(ColorRGBA.White);
                    this.playerMaterial.setColor("Color", ColorRGBA.Gray);
                    this.floorMaterial.setColor("Color", ColorRGBA.LightGray);
                    break;
                }
                case 3: {
                    this.obstacleColors.set(0, ColorRGBA.Pink);
                    break;
                }
                case 4: {
                    this.obstacleColors.set(0, ColorRGBA.Cyan);
                    this.obstacleColors.add(ColorRGBA.Magenta);
                    this.renderer.setBackgroundColor(ColorRGBA.Gray);
                    this.floorMaterial.setColor("Color", ColorRGBA.Gray);
                    this.playerMaterial.setColor("Color", ColorRGBA.White);
                    break;
                }
                case 5: {
                    this.obstacleColors.remove(0);
                    this.renderer.setBackgroundColor(ColorRGBA.Pink);
                    this.solidBox = false;
                    this.playerMaterial.setColor("Color", ColorRGBA.White);
                    break;
                }
                case 6: {
                    this.obstacleColors.set(0, ColorRGBA.White);
                    this.solidBox = true;
                    this.renderer.setBackgroundColor(ColorRGBA.Black);
                    this.playerMaterial.setColor("Color", ColorRGBA.Gray);
                    this.floorMaterial.setColor("Color", ColorRGBA.LightGray);
                    break;
                }
                case 7: {
                    this.obstacleColors.set(0, ColorRGBA.Green);
                    this.renderer.setBackgroundColor(ColorRGBA.Gray);
                    this.playerMaterial.setColor("Color", ColorRGBA.Black);
                    this.floorMaterial.setColor("Color", ColorRGBA.Orange);
                    break;
                }
                case 8: {
                    this.obstacleColors.set(0, ColorRGBA.Red);
                    this.floorMaterial.setColor("Color", ColorRGBA.Pink);
                    break;
                }
                case 9: {
                    this.obstacleColors.set(0, ColorRGBA.Orange);
                    this.obstacleColors.add(ColorRGBA.Red);
                    this.obstacleColors.add(ColorRGBA.Yellow);
                    this.renderer.setBackgroundColor(ColorRGBA.White);
                    this.playerMaterial.setColor("Color", ColorRGBA.Red);
                    this.floorMaterial.setColor("Color", ColorRGBA.Gray);
                    this.colorInt = 0;
                    break;
                }
            }
        }
    }

    private void loadText(BitmapText txt, String text, BitmapFont font, float x, float y, float z) {
        txt.setSize((float)font.getCharSet().getRenderedSize());
        txt.setLocalTranslation(txt.getLineWidth() * x, txt.getLineHeight() * y, z);
        txt.setText(text);
        this.guiNode.attachChild((Spatial)txt);
    }
}

