/*
 * Decompiled with CFR 0.152.
 */
package jme3test.blender.config;

import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class BlenderKeyConfiguration
implements Savable {
    Map<String, Map<String, BlenderKey>> blenderKeys = new HashMap<String, Map<String, BlenderKey>>();
    Map<String, List<String[]>> selectedAnimations = new HashMap<String, List<String[]>>();
    String lastVersionUsed;
    Map<String, BlenderKey> lastUsedKey = new HashMap<String, BlenderKey>();
    Level logLevel = Level.INFO;
    boolean useModelKey;

    public String getLastVersionUsed() {
        return this.lastVersionUsed;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public ModelKey getKeyToUse() {
        return this.useModelKey ? new ModelKey(this.lastUsedKey.get(this.lastVersionUsed).getName()) : (ModelKey)this.lastUsedKey.get(this.lastVersionUsed);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.blenderKeys.size(), "versions-count", 0);
        int i = 0;
        for (Map.Entry<String, Map<String, BlenderKey>> entry : this.blenderKeys.entrySet()) {
            oc.write(entry.getKey(), "key" + i, null);
            oc.writeStringSavableMap(entry.getValue(), "value" + i++, null);
        }
        oc.writeStringSavableMap(this.lastUsedKey, "last-key", null);
        if (this.selectedAnimations == null) {
            oc.write(0, "selected-animations-count", 0);
        } else {
            i = 0;
            oc.write(this.selectedAnimations.size(), "selected-animations-count", 0);
            for (Map.Entry<String, Object> entry : this.selectedAnimations.entrySet()) {
                oc.write(entry.getKey(), "animKey" + i, null);
                oc.write((String[][])((List)entry.getValue()).toArray((T[])new String[this.selectedAnimations.size()][]), "animVal" + i++, (String[][])null);
            }
        }
        oc.write(this.useModelKey, "use-model-key", false);
        oc.write(this.logLevel == null ? null : this.logLevel.getName(), "log-level", Level.INFO.getName());
        oc.write(this.lastVersionUsed, "versionUsed", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule((Savable)this);
        int versionsCount = ic.readInt("versions-count", 0);
        for (int i = 0; i < versionsCount; ++i) {
            String versionName = ic.readString("key" + i, null);
            Map versionBlenderFiles = ic.readStringSavableMap("value" + i, null);
            this.blenderKeys.put(versionName, versionBlenderFiles);
        }
        int selectedAnimCount = ic.readInt("selected-animations-count", 0);
        if (selectedAnimCount > 0) {
            for (int i = 0; i < selectedAnimCount; ++i) {
                String blenderKeyName = ic.readString("animKey" + i, null);
                String[][] selectedAnimations = ic.readStringArray2D("animVal" + i, (String[][])null);
                List anims = Arrays.asList(selectedAnimations);
                this.selectedAnimations.put(blenderKeyName, anims);
            }
        }
        this.lastUsedKey = ic.readStringSavableMap("last-key", null);
        this.useModelKey = ic.readBoolean("use-model-key", false);
        String logLevelName = ic.readString("log-level", Level.INFO.getName());
        this.logLevel = logLevelName == null ? Level.INFO : Level.parse(logLevelName);
        this.lastVersionUsed = ic.readString("versionUsed", null);
    }
}

