/*
 * Decompiled with CFR 0.152.
 */
package jme3test.blender.config;

import com.jme3.asset.BlenderKey;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import jme3test.blender.config.AbstractConfigDialog;
import jme3test.blender.config.BlenderKeyConfiguration;

public class ConfigDialog
extends AbstractConfigDialog {
    private static final long serialVersionUID = 2863364888664674247L;
    private static final Logger LOGGER = Logger.getLogger(ConfigDialog.class.getName());
    private String baseFolderName;
    private BlenderKeyConfiguration blenderKeyConfiguration;

    public ConfigDialog(String baseFolderName) {
        File[] folders;
        if (baseFolderName == null) {
            throw new IllegalArgumentException("No test asset folder given!");
        }
        this.baseFolderName = baseFolderName;
        File baseFolder = new File(baseFolderName);
        if (!baseFolder.exists() || !baseFolder.isDirectory()) {
            throw new IllegalArgumentException("The given base folder path either does not exists or does not point to a directory!");
        }
        for (File folder : folders = baseFolder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().charAt(0) != '.';
            }
        })) {
            ((DefaultComboBoxModel)this.jComboBoxVersionSelection.getModel()).addElement(folder.getName());
        }
        this.loadConfiguration();
        this.applyConfiguration();
        this.initListeners();
        this.setVisible(true);
    }

    public BlenderKeyConfiguration getBlenderKeyConfiguration() {
        return this.blenderKeyConfiguration;
    }

    private void loadConfiguration() {
        File baseFolder = new File(this.baseFolderName);
        Object[] configFiles = baseFolder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.canRead() && file.getName().endsWith(".conf");
            }
        });
        if (configFiles == null || configFiles.length == 0) {
            this.blenderKeyConfiguration = new BlenderKeyConfiguration();
        } else {
            BinaryImporter jmeImporter = new BinaryImporter();
            String instructionToUser = configFiles.length == 1 ? "No other config file to load! No configuration set!" : "Please choose different config file!";
            do {
                File configFile;
                if ((configFile = configFiles.length > 1 ? (File)JOptionPane.showInputDialog(null, "Choose the config file!", "Config file selection", 1, null, configFiles, configFiles[0]) : configFiles[0]) == null) {
                    JOptionPane.showMessageDialog(this, "No config file selected!\nEmpty configuration will be created!", "No configuration selected", 1);
                    this.blenderKeyConfiguration = new BlenderKeyConfiguration();
                    continue;
                }
                try {
                    Savable loadedData = jmeImporter.load(configFile);
                    if (loadedData instanceof BlenderKeyConfiguration) {
                        this.blenderKeyConfiguration = (BlenderKeyConfiguration)loadedData;
                        continue;
                    }
                    LOGGER.warning("Cannot load data drom the given file!");
                    JOptionPane.showMessageDialog(this, "The data stored in the config file is of invalid type!\n" + instructionToUser, "Config data error", 0);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Unable to load configuration! Reason: " + e.getLocalizedMessage(), "Loading data error", 0);
                    LOGGER.severe("Unable to load configuration");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Unable to load configuration!", "Loading data error", 0);
                    LOGGER.log(Level.SEVERE, "Unable to load configuration due to unpredicted error!", e);
                }
            } while (this.blenderKeyConfiguration == null && configFiles.length > 1);
        }
    }

    private void applyConfiguration() {
        String blenderKeyName;
        List<String[]> selectedAnimations;
        this.jCheckBoxUseModelKey.setSelected(this.blenderKeyConfiguration.useModelKey);
        if (this.blenderKeyConfiguration.lastVersionUsed != null) {
            this.jComboBoxVersionSelection.setSelectedItem(this.blenderKeyConfiguration.lastVersionUsed);
        } else {
            this.jComboBoxVersionSelection.setSelectedIndex(0);
            this.blenderKeyConfiguration.lastVersionUsed = (String)this.jComboBoxVersionSelection.getSelectedItem();
        }
        AbstractConfigDialog.JRadioButtonLevel.setSelectedLevel(this.blenderKeyConfiguration.logLevel);
        this.reloadFilesList();
        DefaultTableModel model = (DefaultTableModel)this.jTableAnimations.getModel();
        BlenderKey blenderKey = this.blenderKeyConfiguration.lastUsedKey.get(this.blenderKeyConfiguration.lastVersionUsed);
        if (blenderKey != null && (selectedAnimations = this.blenderKeyConfiguration.selectedAnimations.get(blenderKeyName = blenderKey.getName())) != null) {
            block0: for (String[] selectedAnimation : selectedAnimations) {
                for (int i = 0; i < model.getRowCount(); ++i) {
                    String objectName = (String)model.getValueAt(i, 1);
                    String animationName = (String)model.getValueAt(i, 2);
                    if (!selectedAnimation[0].equals(objectName) || !selectedAnimation[1].equals(animationName)) continue;
                    model.setValueAt(Boolean.TRUE, i, 0);
                    continue block0;
                }
            }
        }
    }

    private void reloadFilesList() {
        File testAssetsFolder = new File(this.baseFolderName + '/' + this.blenderKeyConfiguration.lastVersionUsed);
        File[] blenderFiles = testAssetsFolder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.canRead() && file.getName().endsWith(".blend");
            }
        });
        BlenderKey lastUsedKey = this.blenderKeyConfiguration.lastUsedKey.get(this.blenderKeyConfiguration.lastVersionUsed);
        String lastFileUsed = null;
        if (lastUsedKey != null) {
            lastFileUsed = lastUsedKey.getName().substring(lastUsedKey.getName().lastIndexOf(47) + 1);
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.jListBlenderFiles.getModel();
        defaultListModel.removeAllElements();
        for (int i = 0; i < blenderFiles.length; ++i) {
            defaultListModel.addElement(new AbstractConfigDialog.FileListItem(blenderFiles[i]));
            if (lastFileUsed == null || !lastFileUsed.equals(blenderFiles[i].getName())) continue;
            this.jListBlenderFiles.setSelectedIndex(i);
            this.setBlenderKey(lastUsedKey);
        }
    }

    private void setBlenderKey(BlenderKey blenderKey) {
        Field[] fields;
        AbstractConfigDialog.BlenderTableModel propertiesModel = (AbstractConfigDialog.BlenderTableModel)this.jTableProperties.getModel();
        int rowCount = propertiesModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            propertiesModel.removeRow(0);
        }
        for (Field field : fields = blenderKey.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if ("animations".equalsIgnoreCase(field.getName()) || (field.getModifiers() & 8) != 0) continue;
            try {
                propertiesModel.addRow(new Object[]{field.getName(), field.get(blenderKey)});
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        DefaultTableModel animationsModel = (DefaultTableModel)this.jTableAnimations.getModel();
        rowCount = animationsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            animationsModel.removeRow(0);
        }
        Map animations = blenderKey.getAnimations();
        if (animations != null) {
            for (Map.Entry animationEntry : animations.entrySet()) {
                for (Map.Entry animDataEntry : ((Map)animationEntry.getValue()).entrySet()) {
                    int[] frames = (int[])animDataEntry.getValue();
                    animationsModel.addRow(new Object[]{Boolean.FALSE, animationEntry.getKey(), animDataEntry.getKey(), frames[0], frames[1]});
                }
            }
        }
        this.jButtonOK.setEnabled(true);
        this.jButtonOK.requestFocusInWindow();
        this.jButtonAddAnimation.setEnabled(true);
    }

    private void storeConfig(BlenderKeyConfiguration configuration) {
        configuration.selectedAnimations.clear();
        BlenderKey blenderKey = configuration.lastUsedKey.get(configuration.lastVersionUsed);
        if (blenderKey != null) {
            DefaultTableModel animationsTableModel = (DefaultTableModel)this.jTableAnimations.getModel();
            if (blenderKey.getAnimations() != null) {
                blenderKey.getAnimations().clear();
            }
            int animCounter = 0;
            ArrayList<String[]> selectedAnimations = new ArrayList<String[]>();
            for (int i = 0; i < animationsTableModel.getRowCount(); ++i) {
                Boolean isSelected = (Boolean)animationsTableModel.getValueAt(i, 0);
                String objectName = (String)animationsTableModel.getValueAt(i, 1);
                String animName = (String)animationsTableModel.getValueAt(i, 2);
                Number startFrame = (Number)animationsTableModel.getValueAt(i, 3);
                Number stopFrame = (Number)animationsTableModel.getValueAt(i, 4);
                if (objectName != null && animName != null && startFrame.intValue() <= stopFrame.intValue()) {
                    blenderKey.addAnimation(objectName, animName, startFrame.intValue(), stopFrame.intValue());
                    ++animCounter;
                }
                if (!isSelected.booleanValue()) continue;
                selectedAnimations.add(new String[]{objectName, animName});
            }
            if (selectedAnimations.size() > 0) {
                configuration.selectedAnimations.put(blenderKey.getName(), selectedAnimations);
            }
            if (animCounter < animationsTableModel.getRowCount()) {
                JOptionPane.showMessageDialog(this, "Some animations had errors!\nThey had not been added!", "Invalid animations definitions", 2);
            }
        }
        configuration.useModelKey = this.jCheckBoxUseModelKey.isSelected();
        configuration.logLevel = AbstractConfigDialog.JRadioButtonLevel.getSelectedLevel();
        BinaryExporter jmeExporter = new BinaryExporter();
        try {
            if (!jmeExporter.save((Savable)configuration, new File(this.baseFolderName, "test.conf"))) {
                JOptionPane.showMessageDialog(this, "Unable to save the config data!", "Config save problem", 0);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error occured during config saving!\nReason: " + e.getLocalizedMessage(), "Config save problem", 0);
        }
    }

    private void initListeners() {
        this.jComboBoxVersionSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((ConfigDialog)ConfigDialog.this).blenderKeyConfiguration.lastVersionUsed = ConfigDialog.this.jComboBoxVersionSelection.getSelectedItem().toString();
                ConfigDialog.this.reloadFilesList();
            }
        });
        this.jListBlenderFiles.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                BlenderKeyConfiguration config = ConfigDialog.this.blenderKeyConfiguration;
                AbstractConfigDialog.FileListItem selectedItem = (AbstractConfigDialog.FileListItem)ConfigDialog.this.jListBlenderFiles.getSelectedValue();
                String blenderVersion = config.lastVersionUsed;
                if (selectedItem != null) {
                    String blenderFileName = selectedItem.getFile().getName();
                    BlenderKey blenderKey = null;
                    Map<String, BlenderKey> blenderKeys = config.blenderKeys.get(blenderVersion);
                    if (blenderKeys != null) {
                        blenderKey = blenderKeys.get(blenderFileName);
                        if (blenderKey == null) {
                            blenderKey = new BlenderKey(ConfigDialog.this.baseFolderName + '/' + blenderVersion + '/' + blenderFileName);
                        }
                    } else {
                        blenderKeys = new HashMap<String, BlenderKey>();
                        blenderKey = new BlenderKey(ConfigDialog.this.baseFolderName + '/' + blenderVersion + '/' + blenderFileName);
                        blenderKeys.put(blenderFileName, blenderKey);
                        config.blenderKeys.put(blenderVersion, blenderKeys);
                    }
                    config.lastUsedKey.put(blenderVersion, blenderKey);
                    ConfigDialog.this.setBlenderKey(config.lastUsedKey.get(blenderVersion));
                } else {
                    config.lastUsedKey.put(blenderVersion, null);
                }
            }
        });
        this.jTableProperties.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() == 0) {
                    BlenderKeyConfiguration config = ConfigDialog.this.blenderKeyConfiguration;
                    int row = evt.getFirstRow();
                    String name = (String)ConfigDialog.this.jTableProperties.getModel().getValueAt(row, 0);
                    Object value = ConfigDialog.this.jTableProperties.getModel().getValueAt(row, 1);
                    BlenderKey blenderKey = config.lastUsedKey.get(config.lastVersionUsed);
                    try {
                        Field field = blenderKey.getClass().getDeclaredField(name);
                        field.setAccessible(true);
                        field.set(blenderKey, value);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (SecurityException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (NoSuchFieldException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        });
        this.jTableAnimations.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() == 1) {
                    ConfigDialog.this.jButtonRemoveAnimation.setEnabled(true);
                } else if (evt.getType() == -1 && ConfigDialog.this.jTableAnimations.getModel().getRowCount() == 0) {
                    ConfigDialog.this.jButtonRemoveAnimation.setEnabled(false);
                }
            }
        });
        this.jButtonAddAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((DefaultTableModel)ConfigDialog.this.jTableAnimations.getModel()).addRow(new Object[]{Boolean.FALSE, "", "", 1, 25});
            }
        });
        this.jButtonRemoveAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int row = ConfigDialog.this.jTableAnimations.getSelectedRow();
                if (row >= 0) {
                    ((DefaultTableModel)ConfigDialog.this.jTableAnimations.getModel()).removeRow(row);
                }
            }
        });
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.storeConfig(ConfigDialog.this.blenderKeyConfiguration);
                ConfigDialog.this.dispose();
            }
        });
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.storeConfig(ConfigDialog.this.blenderKeyConfiguration);
                ConfigDialog.this.blenderKeyConfiguration = null;
                ConfigDialog.this.dispose();
            }
        });
    }
}

