/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.GhostControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import jme3test.bullet.PhysicsTestHelper;

public class TestGhostObject
extends SimpleApplication {
    private BulletAppState bulletAppState;
    private GhostControl ghostControl;

    public static void main(String[] args) {
        TestGhostObject app = new TestGhostObject();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        Box boxGeom = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        BoxCollisionShape shape = new BoxCollisionShape(new Vector3f(1.0f, 1.0f, 1.0f));
        Node physicsBox = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)shape, 1.0f);
        physicsBox.setName("box0");
        ((RigidBodyControl)physicsBox.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.6f, 4.0f, 0.5f));
        this.rootNode.attachChild((Spatial)physicsBox);
        this.getPhysicsSpace().add((Object)physicsBox);
        Node physicsBox1 = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)shape, 1.0f);
        physicsBox1.setName("box1");
        ((RigidBodyControl)physicsBox1.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.0f, 40.0f, 0.0f));
        this.rootNode.attachChild((Spatial)physicsBox1);
        this.getPhysicsSpace().add((Object)physicsBox1);
        Node physicsBox2 = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new BoxCollisionShape(new Vector3f(1.0f, 1.0f, 1.0f)), 1.0f);
        physicsBox2.setName("box0");
        ((RigidBodyControl)physicsBox2.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.5f, 80.0f, -0.8f));
        this.rootNode.attachChild((Spatial)physicsBox2);
        this.getPhysicsSpace().add((Object)physicsBox2);
        Node node = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new BoxCollisionShape(new Vector3f(100.0f, 1.0f, 100.0f)), 0.0f);
        node.setName("floor");
        ((RigidBodyControl)node.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.0f, -6.0f, 0.0f));
        this.rootNode.attachChild((Spatial)node);
        this.getPhysicsSpace().add((Object)node);
        this.initGhostObject();
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    private void initGhostObject() {
        Vector3f halfExtents = new Vector3f(3.0f, 4.2f, 1.0f);
        this.ghostControl = new GhostControl((CollisionShape)new BoxCollisionShape(halfExtents));
        Node node = new Node("Ghost Object");
        node.addControl((Control)this.ghostControl);
        this.rootNode.attachChild((Spatial)node);
        this.getPhysicsSpace().add((Object)this.ghostControl);
    }

    public void simpleUpdate(float tpf) {
        this.fpsText.setText("Overlapping objects: " + this.ghostControl.getOverlappingObjects().toString());
    }
}

