/*
 * Decompiled with CFR 0.152.
 */
package jme3test.conversion;

import com.jme3.app.SimpleApplication;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import jme3tools.converters.MipMapGenerator;

public class TestMipMapGen
extends SimpleApplication {
    public static void main(String[] args) {
        TestMipMapGen app = new TestMipMapGen();
        app.start();
    }

    public void simpleInitApp() {
        BitmapText txt = this.guiFont.createLabel("Left: HW Mips");
        txt.setLocalTranslation(0.0f, (float)this.settings.getHeight() - txt.getLineHeight() * 4.0f, 0.0f);
        this.guiNode.attachChild((Spatial)txt);
        txt = this.guiFont.createLabel("Right: AWT Mips");
        txt.setLocalTranslation(0.0f, (float)this.settings.getHeight() - txt.getLineHeight() * 3.0f, 0.0f);
        this.guiNode.attachChild((Spatial)txt);
        Quad quadMesh = new Quad(1.0f, 1.0f);
        quadMesh.updateGeometry(1.0f, 1.0f, false);
        quadMesh.updateBound();
        Geometry quad1 = new Geometry("Textured Quad", (Mesh)quadMesh);
        Geometry quad2 = new Geometry("Textured Quad 2", (Mesh)quadMesh);
        Texture tex = this.assetManager.loadTexture("Interface/Logo/Monkey.png");
        tex.setMinFilter(Texture.MinFilter.Trilinear);
        Texture texCustomMip = tex.clone();
        Image imageCustomMip = texCustomMip.getImage().clone();
        MipMapGenerator.generateMipMaps((Image)imageCustomMip);
        texCustomMip.setImage(imageCustomMip);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setTexture("ColorMap", tex);
        Material mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat2.setTexture("ColorMap", texCustomMip);
        quad1.setMaterial(mat1);
        quad2.setMaterial(mat2);
        quad2.setLocalTranslation(1.0f, 0.0f, 0.0f);
        this.rootNode.attachChild((Spatial)quad1);
        this.rootNode.attachChild((Spatial)quad2);
    }
}

