/*
 * Decompiled with CFR 0.152.
 */
package jme3test.effect;

import com.jme3.app.SimpleApplication;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.effect.shapes.EmitterSphereShape;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TestParticleExportingCloning
extends SimpleApplication {
    public static void main(String[] args) {
        TestParticleExportingCloning app = new TestParticleExportingCloning();
        app.start();
    }

    public void simpleInitApp() {
        ParticleEmitter emit = new ParticleEmitter("Emitter", ParticleMesh.Type.Triangle, 200);
        emit.setShape((EmitterShape)new EmitterSphereShape(Vector3f.ZERO, 1.0f));
        emit.setGravity(0.0f, 0.0f, 0.0f);
        emit.setLowLife(5.0f);
        emit.setHighLife(10.0f);
        emit.setInitialVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
        emit.setImagesX(15);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Smoke/Smoke.png"));
        emit.setMaterial(mat);
        ParticleEmitter emit2 = emit.clone();
        emit2.move(3.0f, 0.0f, 0.0f);
        this.rootNode.attachChild((Spatial)emit);
        this.rootNode.attachChild((Spatial)emit2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BinaryExporter.getInstance().save((Savable)emit, (OutputStream)out);
            BinaryImporter imp = new BinaryImporter();
            imp.setAssetManager(this.assetManager);
            ParticleEmitter emit3 = (ParticleEmitter)imp.load(out.toByteArray());
            emit3.move(-3.0f, 0.0f, 0.0f);
            this.rootNode.attachChild((Spatial)emit3);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

