/*
 * Decompiled with CFR 0.152.
 */
package jme3test.input;

import com.jme3.app.SimpleApplication;
import com.jme3.input.ChaseCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;

public class TestChaseCamera
extends SimpleApplication
implements AnalogListener,
ActionListener {
    private Geometry teaGeom;
    private ChaseCamera chaseCam;

    public static void main(String[] args) {
        TestChaseCamera app = new TestChaseCamera();
        app.start();
    }

    public void simpleInitApp() {
        this.teaGeom = (Geometry)this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        Material mat_tea = new Material(this.assetManager, "Common/MatDefs/Misc/ShowNormals.j3md");
        this.teaGeom.setMaterial(mat_tea);
        this.rootNode.attachChild((Spatial)this.teaGeom);
        Material mat_ground = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat_ground.setTexture("ColorMap", this.assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Geometry ground = new Geometry("ground", (Mesh)new Quad(50.0f, 50.0f));
        ground.setLocalRotation(new Quaternion().fromAngleAxis(-1.5707964f, Vector3f.UNIT_X));
        ground.setLocalTranslation(-25.0f, -1.0f, 25.0f);
        ground.setMaterial(mat_ground);
        this.rootNode.attachChild((Spatial)ground);
        this.flyCam.setEnabled(false);
        this.chaseCam = new ChaseCamera(this.cam, (Spatial)this.teaGeom, this.inputManager);
        this.chaseCam.setSmoothMotion(true);
        this.registerInput();
    }

    public void registerInput() {
        Trigger[] triggerArray = new Trigger[2];
        triggerArray[0] = new KeyTrigger(200);
        triggerArray[1] = new KeyTrigger(17);
        this.inputManager.addMapping("moveForward", triggerArray);
        Trigger[] triggerArray2 = new Trigger[2];
        triggerArray2[0] = new KeyTrigger(208);
        triggerArray2[1] = new KeyTrigger(31);
        this.inputManager.addMapping("moveBackward", triggerArray2);
        Trigger[] triggerArray3 = new Trigger[2];
        triggerArray3[0] = new KeyTrigger(205);
        triggerArray3[1] = new KeyTrigger(32);
        this.inputManager.addMapping("moveRight", triggerArray3);
        Trigger[] triggerArray4 = new Trigger[2];
        triggerArray4[0] = new KeyTrigger(203);
        triggerArray4[1] = new KeyTrigger(30);
        this.inputManager.addMapping("moveLeft", triggerArray4);
        Trigger[] triggerArray5 = new Trigger[1];
        triggerArray5[0] = new KeyTrigger(25);
        this.inputManager.addMapping("displayPosition", triggerArray5);
        this.inputManager.addListener((InputListener)this, new String[]{"moveForward", "moveBackward", "moveRight", "moveLeft"});
        this.inputManager.addListener((InputListener)this, new String[]{"displayPosition"});
    }

    public void onAnalog(String name, float value, float tpf) {
        if (name.equals("moveForward")) {
            this.teaGeom.move(0.0f, 0.0f, -5.0f * tpf);
        }
        if (name.equals("moveBackward")) {
            this.teaGeom.move(0.0f, 0.0f, 5.0f * tpf);
        }
        if (name.equals("moveRight")) {
            this.teaGeom.move(5.0f * tpf, 0.0f, 0.0f);
        }
        if (name.equals("moveLeft")) {
            this.teaGeom.move(-5.0f * tpf, 0.0f, 0.0f);
        }
    }

    public void onAction(String name, boolean keyPressed, float tpf) {
        if (name.equals("displayPosition") && keyPressed) {
            this.teaGeom.move(10.0f, 10.0f, 10.0f);
        }
    }

    public void simpleUpdate(float tpf) {
        super.simpleUpdate(tpf);
    }
}

