/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;

public class TestSimpleLighting
extends SimpleApplication {
    float angle;
    PointLight pl;
    Geometry lightMdl;

    public static void main(String[] args) {
        TestSimpleLighting app = new TestSimpleLighting();
        app.start();
    }

    public void simpleInitApp() {
        Geometry teapot = (Geometry)this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        TangentBinormalGenerator.generate((Mesh)teapot.getMesh(), (boolean)true);
        teapot.setLocalScale(2.0f);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 12.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setColor("Ambient", ColorRGBA.Black);
        mat.setColor("Diffuse", ColorRGBA.Gray);
        mat.setColor("Specular", ColorRGBA.Gray);
        teapot.setMaterial(mat);
        this.rootNode.attachChild((Spatial)teapot);
        this.lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.lightMdl.getMesh().setStatic();
        this.rootNode.attachChild((Spatial)this.lightMdl);
        this.pl = new PointLight();
        this.pl.setColor(ColorRGBA.White);
        this.pl.setRadius(4.0f);
        this.rootNode.addLight((Light)this.pl);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        dl.setColor(ColorRGBA.Green);
        this.rootNode.addLight((Light)dl);
    }

    public void simpleUpdate(float tpf) {
        this.angle += tpf;
        this.angle %= (float)Math.PI * 2;
        this.pl.setPosition(new Vector3f(FastMath.cos((float)this.angle) * 2.0f, 0.5f, FastMath.sin((float)this.angle) * 2.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
    }
}

