/*
 * Decompiled with CFR 0.152.
 */
package jme3test.material;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetKey;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.ogre.OgreMeshKey;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;

public class TestBumpModel
extends SimpleApplication {
    float angle;
    PointLight pl;
    Spatial lightMdl;

    public static void main(String[] args) {
        TestBumpModel app = new TestBumpModel();
        app.start();
    }

    public void simpleInitApp() {
        Spatial signpost = (Spatial)this.assetManager.loadAsset((AssetKey)new OgreMeshKey("Models/Sign Post/Sign Post.mesh.xml"));
        signpost.setMaterial(this.assetManager.loadMaterial("Models/Sign Post/Sign Post.j3m"));
        TangentBinormalGenerator.generate((Spatial)signpost);
        this.rootNode.attachChild(signpost);
        this.lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.rootNode.attachChild(this.lightMdl);
        this.pl = new PointLight();
        this.pl.setColor(new ColorRGBA(0.88f, 0.92f, 0.95f, 1.0f));
        this.rootNode.addLight((Light)this.pl);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.1f, -0.7f, 1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.44f, 0.3f, 0.2f, 1.0f));
        this.rootNode.addLight((Light)dl);
        dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.6f, -1.0f, -0.6f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.1f, 0.22f, 0.44f, 1.0f));
        this.rootNode.addLight((Light)dl);
        dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, -0.5f, -0.1f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.5f, 0.4f, 0.5f, 1.0f));
        this.rootNode.addLight((Light)dl);
    }

    public void simpleUpdate(float tpf) {
        this.angle += tpf * 0.25f;
        this.angle %= (float)Math.PI * 2;
        this.pl.setPosition(new Vector3f(FastMath.cos((float)this.angle) * 6.0f, 3.0f, FastMath.sin((float)this.angle) * 6.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
    }
}

