/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network;

import com.jme3.network.Client;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.sync.MovingAverage;
import java.io.IOException;

public class TestLatency {
    private static long startTime;
    private static Client client;
    private static MovingAverage average;

    private static long getTime() {
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        Object obj;
        Serializer.registerClass(TimestampMessage.class);
        Server server = Network.createServer((int)5110);
        server.start();
        client = Network.connectToServer((String)"localhost", (int)5110);
        client.start();
        client.addMessageListener((MessageListener)new MessageListener<Client>(){

            public void messageReceived(Client source, Message m) {
                TimestampMessage timeMsg = (TimestampMessage)m;
                long curTime = TestLatency.getTime();
                long latency = curTime - timeMsg.timeSent;
                System.out.println("Latency: " + latency + " ms");
                average.add(latency);
                System.out.println("Average latency: " + average.getAverage());
                long latencyOffset = latency - average.getAverage();
                System.out.println("Latency offset: " + latencyOffset);
                client.send((Message)new TimestampMessage(TestLatency.getTime(), 0L));
            }
        }, new Class[]{TimestampMessage.class});
        server.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message m) {
                TimestampMessage timeMsg = (TimestampMessage)m;
                TimestampMessage outMsg = new TimestampMessage(timeMsg.timeSent, TestLatency.getTime());
                source.send((Message)outMsg);
            }
        }, new Class[]{TimestampMessage.class});
        Thread.sleep(1L);
        client.send((Message)new TimestampMessage(TestLatency.getTime(), 0L));
        Object object = obj = new Object();
        synchronized (object) {
            obj.wait();
        }
    }

    static {
        average = new MovingAverage(100);
        startTime = System.currentTimeMillis();
    }

    @Serializable
    public static class TimestampMessage
    extends com.jme3.network.message.Message {
        long timeSent = 0L;
        long timeReceived = 0L;

        public TimestampMessage() {
            this.setReliable(false);
        }

        public TimestampMessage(long timeSent, long timeReceived) {
            this.setReliable(false);
            this.timeSent = timeSent;
            this.timeReceived = timeReceived;
        }
    }
}

