/*
 * Decompiled with CFR 0.152.
 */
package jme3test.niftygui;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import de.lessvoid.nifty.Nifty;

public class TestNiftyToMesh
extends SimpleApplication {
    private Nifty nifty;

    public static void main(String[] args) {
        TestNiftyToMesh app = new TestNiftyToMesh();
        app.start();
    }

    public void simpleInitApp() {
        ViewPort niftyView = this.renderManager.createPreView("NiftyView", new Camera(1024, 768));
        niftyView.setClearFlags(true, true, true);
        NiftyJmeDisplay niftyDisplay = new NiftyJmeDisplay(this.assetManager, this.inputManager, this.audioRenderer, niftyView);
        this.nifty = niftyDisplay.getNifty();
        this.nifty.fromXml("all/intro.xml", "start");
        niftyView.addProcessor((SceneProcessor)niftyDisplay);
        Texture2D depthTex = new Texture2D(1024, 768, Image.Format.Depth);
        FrameBuffer fb = new FrameBuffer(1024, 768, 1);
        fb.setDepthTexture(depthTex);
        Texture2D tex = new Texture2D(1024, 768, Image.Format.RGBA8);
        tex.setMinFilter(Texture.MinFilter.Trilinear);
        tex.setMagFilter(Texture.MagFilter.Bilinear);
        fb.setColorTexture(tex);
        niftyView.setClearFlags(true, true, true);
        niftyView.setOutputFrameBuffer(fb);
        Box b = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Geometry geom = new Geometry("Box", (Mesh)b);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", (Texture)tex);
        geom.setMaterial(mat);
        this.rootNode.attachChild((Spatial)geom);
    }
}

