/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.FogFilter;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SkyFactory;
import java.io.File;

public class TestFog
extends SimpleApplication {
    private FilterPostProcessor fpp;
    private boolean enabled = true;
    private FogFilter fog;
    private static boolean useHttp = true;

    public static void main(String[] args) {
        File file = new File("wildhouse.zip");
        if (file.exists()) {
            useHttp = false;
        }
        TestFog app = new TestFog();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        Node mainScene = new Node();
        this.cam.setLocation(new Vector3f(-27.0f, 1.0f, 75.0f));
        this.cam.setRotation(new Quaternion(0.03f, 0.9f, 0.0f, 0.4f));
        mainScene.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
        if (useHttp) {
            this.assetManager.registerLocator("http://jmonkeyengine.googlecode.com/files/wildhouse.zip", HttpZipLocator.class.getName());
        } else {
            this.assetManager.registerLocator("wildhouse.zip", ZipLocator.class.getName());
        }
        Spatial scene = this.assetManager.loadModel("main.scene");
        DirectionalLight sun = new DirectionalLight();
        Vector3f lightDir = new Vector3f(-0.37352666f, -0.50444174f, -0.7784704f);
        sun.setDirection(lightDir);
        sun.setColor(ColorRGBA.White.clone().multLocal(2.0f));
        scene.addLight((Light)sun);
        mainScene.attachChild(scene);
        this.rootNode.attachChild((Spatial)mainScene);
        this.fpp = new FilterPostProcessor(this.assetManager);
        this.fog = new FogFilter();
        this.fog.setFogColor(new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        this.fog.setFogDistance(155.0f);
        this.fog.setFogDensity(2.0f);
        this.fpp.addFilter((Filter)this.fog);
        this.viewPort.addProcessor((SceneProcessor)this.fpp);
        this.initInputs();
    }

    private void initInputs() {
        this.inputManager.addMapping("toggle", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addMapping("DensityUp", new Trigger[]{new KeyTrigger(21)});
        this.inputManager.addMapping("DensityDown", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("DistanceUp", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addMapping("DistanceDown", new Trigger[]{new KeyTrigger(36)});
        ActionListener acl = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                if (name.equals("toggle") && keyPressed) {
                    if (TestFog.this.enabled) {
                        TestFog.this.enabled = false;
                        TestFog.this.viewPort.removeProcessor((SceneProcessor)TestFog.this.fpp);
                    } else {
                        TestFog.this.enabled = true;
                        TestFog.this.viewPort.addProcessor((SceneProcessor)TestFog.this.fpp);
                    }
                }
            }
        };
        AnalogListener anl = new AnalogListener(){

            public void onAnalog(String name, float isPressed, float tpf) {
                if (name.equals("DensityUp")) {
                    TestFog.this.fog.setFogDensity(TestFog.this.fog.getFogDensity() + 0.001f);
                    System.out.println("Fog density : " + TestFog.this.fog.getFogDensity());
                }
                if (name.equals("DensityDown")) {
                    TestFog.this.fog.setFogDensity(TestFog.this.fog.getFogDensity() - 0.01f);
                    System.out.println("Fog density : " + TestFog.this.fog.getFogDensity());
                }
                if (name.equals("DistanceUp")) {
                    TestFog.this.fog.setFogDistance(TestFog.this.fog.getFogDistance() + 0.5f);
                    System.out.println("Fog Distance : " + TestFog.this.fog.getFogDistance());
                }
                if (name.equals("DistanceDown")) {
                    TestFog.this.fog.setFogDistance(TestFog.this.fog.getFogDistance() - 0.5f);
                    System.out.println("Fog Distance : " + TestFog.this.fog.getFogDistance());
                }
            }
        };
        this.inputManager.addListener((InputListener)acl, new String[]{"toggle"});
        this.inputManager.addListener((InputListener)anl, new String[]{"DensityUp", "DensityDown", "DistanceUp", "DistanceDown"});
    }
}

