/*
 * Decompiled with CFR 0.152.
 */
package jme3test.terrain;

import com.jme3.app.SimpleApplication;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainGrid;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.FractalHeightMapGrid;
import com.jme3.terrain.heightmap.HeightMapGrid;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import org.novyon.noise.Basis;
import org.novyon.noise.Filter;
import org.novyon.noise.ShaderUtils;
import org.novyon.noise.basis.FilteredBasis;
import org.novyon.noise.filter.IterativeFilter;
import org.novyon.noise.filter.OptimizedErode;
import org.novyon.noise.filter.PerturbFilter;
import org.novyon.noise.filter.SmoothFilter;
import org.novyon.noise.fractal.FractalSum;
import org.novyon.noise.modulator.Modulator;
import org.novyon.noise.modulator.NoiseModulator;

public class TerrainTestModifyHeight
extends SimpleApplication {
    private TerrainQuad terrain;
    Material matTerrain;
    Material matWire;
    boolean wireframe = true;
    boolean triPlanar = false;
    boolean wardiso = false;
    boolean minnaert = false;
    protected BitmapText hintText;
    private float grassScale = 64.0f;
    private float dirtScale = 16.0f;
    private float rockScale = 128.0f;
    private boolean raiseTerrain = false;
    private boolean lowerTerrain = false;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean pressed, float tpf) {
            if (name.equals("wireframe") && !pressed) {
                boolean bl = TerrainTestModifyHeight.this.wireframe = !TerrainTestModifyHeight.this.wireframe;
                if (!TerrainTestModifyHeight.this.wireframe) {
                    TerrainTestModifyHeight.this.terrain.setMaterial(TerrainTestModifyHeight.this.matWire);
                } else {
                    TerrainTestModifyHeight.this.terrain.setMaterial(TerrainTestModifyHeight.this.matTerrain);
                }
            } else if (name.equals("Raise")) {
                TerrainTestModifyHeight.this.raiseTerrain = pressed;
            } else if (name.equals("Lower")) {
                TerrainTestModifyHeight.this.lowerTerrain = pressed;
            }
        }
    };

    public static void main(String[] args) {
        TerrainTestModifyHeight app = new TerrainTestModifyHeight();
        app.start();
    }

    public void simpleUpdate(float tpf) {
        Vector3f intersection = this.getWorldIntersection();
        this.updateHintText(intersection);
        if (this.raiseTerrain) {
            if (intersection != null) {
                this.adjustHeight(intersection, 64.0f, tpf * 60.0f);
            }
        } else if (this.lowerTerrain && intersection != null) {
            this.adjustHeight(intersection, 64.0f, -tpf * 60.0f);
        }
    }

    public void simpleInitApp() {
        this.loadHintText();
        this.initCrossHairs();
        this.setupKeys();
        this.matWire = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matWire.getAdditionalRenderState().setWireframe(true);
        this.matWire.setColor("Color", ColorRGBA.Green);
        this.createTerrainGrid();
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(-0.5f, -1.0f, -0.5f).normalize());
        this.rootNode.addLight((Light)light);
        AmbientLight ambLight = new AmbientLight();
        ambLight.setColor(new ColorRGBA(1.0f, 1.0f, 0.8f, 0.2f));
        this.rootNode.addLight((Light)ambLight);
        this.cam.setLocation(new Vector3f(0.0f, 256.0f, 0.0f));
        this.cam.lookAtDirection(new Vector3f(0.0f, -1.5f, -1.0f).normalizeLocal(), Vector3f.UNIT_Y);
    }

    public void loadHintText() {
        this.hintText = new BitmapText(this.guiFont, false);
        this.hintText.setLocalTranslation(0.0f, (float)this.getCamera().getHeight(), 0.0f);
        this.hintText.setText("Hit 1 to raise terrain, hit 2 to lower terrain");
        this.guiNode.attachChild((Spatial)this.hintText);
    }

    public void updateHintText(Vector3f target) {
        int x = (int)this.getCamera().getLocation().x;
        int y = (int)this.getCamera().getLocation().y;
        int z = (int)this.getCamera().getLocation().z;
        String targetText = "";
        if (target != null) {
            targetText = "  intersect: " + target.toString();
        }
        this.hintText.setText("Press left mouse button to raise terrain, press right mouse button to lower terrain.  " + x + "," + y + "," + z + targetText);
    }

    protected void initCrossHairs() {
        BitmapText ch = new BitmapText(this.guiFont, false);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2 - this.guiFont.getCharSet().getRenderedSize() / 3 * 2), (float)(this.settings.getHeight() / 2) + ch.getLineHeight() / 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }

    private void setupKeys() {
        this.flyCam.setMoveSpeed(100.0f);
        this.inputManager.addMapping("wireframe", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"wireframe"});
        this.inputManager.addMapping("Raise", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Raise"});
        this.inputManager.addMapping("Lower", new Trigger[]{new MouseButtonTrigger(1)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Lower"});
    }

    private void adjustHeight(Vector3f loc, float radius, float height) {
        int radiusStepsX = (int)(radius / this.terrain.getLocalScale().x);
        int radiusStepsZ = (int)(radius / this.terrain.getLocalScale().z);
        float xStepAmount = this.terrain.getLocalScale().x;
        float zStepAmount = this.terrain.getLocalScale().z;
        long start = System.currentTimeMillis();
        ArrayList<Vector2f> locs = new ArrayList<Vector2f>();
        ArrayList<Float> heights = new ArrayList<Float>();
        for (int z = -radiusStepsZ; z < radiusStepsZ; ++z) {
            for (int x = -radiusStepsX; x < radiusStepsX; ++x) {
                float locX = loc.x + (float)x * xStepAmount;
                float locZ = loc.z + (float)z * zStepAmount;
                if (!this.isInRadius(locX - loc.x, locZ - loc.z, radius)) continue;
                float h = this.calculateHeight(radius, height, locX - loc.x, locZ - loc.z);
                locs.add(new Vector2f(locX, locZ));
                heights.add(Float.valueOf(h));
            }
        }
        this.terrain.adjustHeight(locs, heights);
        this.terrain.updateModelBound();
    }

    private boolean isInRadius(float x, float y, float radius) {
        Vector2f point = new Vector2f(x, y);
        return point.length() <= radius;
    }

    private float calculateHeight(float radius, float heightFactor, float x, float z) {
        Vector2f point = new Vector2f(x, z);
        float val = point.length() / radius;
        if ((val = 1.0f - val) <= 0.0f) {
            val = 0.0f;
        }
        return heightFactor * val;
    }

    private Vector3f getWorldIntersection() {
        Vector3f origin = this.cam.getWorldCoordinates(new Vector2f((float)(this.settings.getWidth() / 2), (float)(this.settings.getHeight() / 2)), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(new Vector2f((float)(this.settings.getWidth() / 2), (float)(this.settings.getHeight() / 2)), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        int numCollisions = this.terrain.collideWith((Collidable)ray, results);
        if (numCollisions > 0) {
            CollisionResult hit = results.getClosestCollision();
            return hit.getContactPoint();
        }
        return null;
    }

    private void createTerrain() {
        this.matTerrain = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matTerrain.setBoolean("useTriPlanarMapping", false);
        this.matTerrain.setBoolean("WardIso", true);
        this.matTerrain.setTexture("AlphaMap", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap", grass);
        this.matTerrain.setFloat("DiffuseMap_0_scale", this.grassScale);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_1", dirt);
        this.matTerrain.setFloat("DiffuseMap_1_scale", this.dirtScale);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_2", rock);
        this.matTerrain.setFloat("DiffuseMap_2_scale", this.rockScale);
        this.terrain = new TerrainQuad("terrain", 65, 513, null);
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, this.getCamera());
        this.terrain.addControl((Control)control);
        this.terrain.setMaterial(this.matTerrain);
        this.terrain.setLocalTranslation(0.0f, -100.0f, 0.0f);
        this.terrain.setLocalScale(2.0f, 1.0f, 2.0f);
        this.rootNode.attachChild((Spatial)this.terrain);
    }

    private void createTerrainGrid() {
        this.matTerrain = new Material(this.assetManager, "Common/MatDefs/Terrain/HeightBasedTerrain.j3md");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("region1ColorMap", grass);
        this.matTerrain.setVector3("region1", new Vector3f(88.0f, 200.0f, this.grassScale));
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("region2ColorMap", dirt);
        this.matTerrain.setVector3("region2", new Vector3f(0.0f, 90.0f, this.dirtScale));
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/Rock2/rock.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("region3ColorMap", rock);
        this.matTerrain.setVector3("region3", new Vector3f(198.0f, 260.0f, this.rockScale));
        this.matTerrain.setTexture("region4ColorMap", rock);
        this.matTerrain.setVector3("region4", new Vector3f(198.0f, 260.0f, this.rockScale));
        this.matTerrain.setTexture("slopeColorMap", rock);
        this.matTerrain.setFloat("slopeTileFactor", 32.0f);
        this.matTerrain.setFloat("terrainSize", 513.0f);
        FractalSum base = new FractalSum();
        base.setRoughness(0.7f);
        base.setFrequency(1.0f);
        base.setAmplitude(1.0f);
        base.setLacunarity(2.12f);
        base.setOctaves(8.0f);
        base.setScale(0.02125f);
        base.addModulator((Modulator)new NoiseModulator(){

            public float value(float ... in) {
                return ShaderUtils.clamp((float)(in[0] * 0.5f + 0.5f), (float)0.0f, (float)1.0f);
            }
        });
        FilteredBasis ground = new FilteredBasis((Basis)base);
        PerturbFilter perturb = new PerturbFilter();
        perturb.setMagnitude(0.119f);
        OptimizedErode therm = new OptimizedErode();
        therm.setRadius(5);
        therm.setTalus(0.011f);
        SmoothFilter smooth = new SmoothFilter();
        smooth.setRadius(1);
        smooth.setEffect(0.7f);
        IterativeFilter iterate = new IterativeFilter();
        iterate.addPreFilter((Filter)perturb);
        iterate.addPostFilter((Filter)smooth);
        iterate.setFilter((Filter)therm);
        iterate.setIterations(1);
        ground.addPreFilter((Filter)iterate);
        this.terrain = new TerrainGrid("terrain", 65, 257, (HeightMapGrid)new FractalHeightMapGrid((Basis)ground, null, 256.0f));
        this.terrain.setMaterial(this.matWire);
        this.terrain.setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.terrain.setLocalScale(2.0f, 1.0f, 2.0f);
        ((TerrainGrid)this.terrain).initialize(Vector3f.ZERO);
        this.rootNode.attachChild((Spatial)this.terrain);
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, this.getCamera());
        this.terrain.addControl((Control)control);
    }
}

