/*
 * Decompiled with CFR 0.152.
 */
package jme3test.terrain;

import com.jme3.app.SimpleApplication;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.converters.ImageToAwt;

public class TerrainTestReadWrite
extends SimpleApplication {
    private Terrain terrain;
    protected BitmapText hintText;
    private float grassScale = 64.0f;
    private float dirtScale = 16.0f;
    private float rockScale = 128.0f;
    private Material matTerrain;
    private Material matWire;
    private ActionListener saveActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAction(String name, boolean pressed, float tpf) {
            if (name.equals("save") && !pressed) {
                FileOutputStream fos = null;
                try {
                    long start = System.currentTimeMillis();
                    fos = new FileOutputStream(new File("terrainsave.jme"));
                    BinaryExporter.getInstance().save((Savable)TerrainTestReadWrite.this.terrain, (OutputStream)new BufferedOutputStream(fos));
                    fos.flush();
                    float duration = (float)(System.currentTimeMillis() - start) / 1000.0f;
                    System.out.println("Save took " + duration + " seconds");
                }
                catch (IOException ex) {
                    Logger.getLogger(TerrainTestReadWrite.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger(TerrainTestReadWrite.class.getName()).log(Level.SEVERE, null, e);
                    }
                }
            }
        }
    };
    private ActionListener loadActionListener = new ActionListener(){

        public void onAction(String name, boolean pressed, float tpf) {
            if (name.equals("load") && !pressed) {
                TerrainTestReadWrite.this.loadTerrain();
            }
        }
    };
    private ActionListener cloneActionListener = new ActionListener(){

        public void onAction(String name, boolean pressed, float tpf) {
            if (name.equals("clone") && !pressed) {
                Terrain clone = (Terrain)((Node)TerrainTestReadWrite.this.terrain).clone();
                ((Node)TerrainTestReadWrite.this.terrain).removeFromParent();
                TerrainTestReadWrite.this.terrain = clone;
                TerrainTestReadWrite.this.getRootNode().attachChild((Spatial)((Node)TerrainTestReadWrite.this.terrain));
            }
        }
    };

    public static void main(String[] args) {
        TerrainTestReadWrite app = new TerrainTestReadWrite();
        app.start();
    }

    public void initialize() {
        super.initialize();
        this.loadHintText();
    }

    public void simpleInitApp() {
        this.createControls();
        this.createMap();
    }

    private void createMap() {
        this.matTerrain = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matTerrain.setBoolean("useTriPlanarMapping", false);
        this.matTerrain.setBoolean("WardIso", true);
        this.matTerrain.setTexture("AlphaMap", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap", grass);
        this.matTerrain.setFloat("DiffuseMap_0_scale", this.grassScale);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_1", dirt);
        this.matTerrain.setFloat("DiffuseMap_1_scale", this.dirtScale);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("DiffuseMap_2", rock);
        this.matTerrain.setFloat("DiffuseMap_2_scale", this.rockScale);
        Texture normalMap0 = this.assetManager.loadTexture("Textures/Terrain/splat/grass_normal.jpg");
        normalMap0.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap1 = this.assetManager.loadTexture("Textures/Terrain/splat/dirt_normal.png");
        normalMap1.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap2 = this.assetManager.loadTexture("Textures/Terrain/splat/road_normal.png");
        normalMap2.setWrap(Texture.WrapMode.Repeat);
        this.matTerrain.setTexture("NormalMap", normalMap0);
        this.matTerrain.setTexture("NormalMap_1", normalMap2);
        this.matTerrain.setTexture("NormalMap_2", normalMap2);
        this.matWire = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matWire.getAdditionalRenderState().setWireframe(true);
        this.matWire.setColor("Color", ColorRGBA.Green);
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap((Image)ImageToAwt.convert((com.jme3.texture.Image)heightMapImage.getImage(), (boolean)false, (boolean)true, (int)0), 1.0f);
            heightmap.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (new File("terrainsave.jme").exists()) {
            this.loadTerrain();
        } else {
            TerrainQuad terrainQuad = new TerrainQuad("terrain", 65, 129, heightmap.getHeightMap());
            TerrainLodControl control = new TerrainLodControl((Terrain)terrainQuad, this.getCamera());
            terrainQuad.addControl((Control)control);
            terrainQuad.setMaterial(this.matTerrain);
            terrainQuad.setLocalTranslation(0.0f, -100.0f, 0.0f);
            terrainQuad.setLocalScale(4.0f, 0.25f, 4.0f);
            this.rootNode.attachChild((Spatial)terrainQuad);
            this.terrain = terrainQuad;
        }
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(-0.5f, -1.0f, -0.5f).normalize());
        this.rootNode.addLight((Light)light);
    }

    private void createControls() {
        this.flyCam.setMoveSpeed(50.0f);
        this.cam.setLocation(new Vector3f(0.0f, 100.0f, 0.0f));
        this.inputManager.addMapping("save", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addListener((InputListener)this.saveActionListener, new String[]{"save"});
        this.inputManager.addMapping("load", new Trigger[]{new KeyTrigger(21)});
        this.inputManager.addListener((InputListener)this.loadActionListener, new String[]{"load"});
        this.inputManager.addMapping("clone", new Trigger[]{new KeyTrigger(46)});
        this.inputManager.addListener((InputListener)this.cloneActionListener, new String[]{"clone"});
    }

    public void loadHintText() {
        this.hintText = new BitmapText(this.guiFont, false);
        this.hintText.setSize((float)this.guiFont.getCharSet().getRenderedSize());
        this.hintText.setLocalTranslation(0.0f, (float)this.getCamera().getHeight(), 0.0f);
        this.hintText.setText("Hit T to save, and Y to load");
        this.guiNode.attachChild((Spatial)this.hintText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTerrain() {
        FileInputStream fis = null;
        try {
            long start = System.currentTimeMillis();
            if (this.terrain != null) {
                Node existingTerrain = (Node)this.terrain;
                existingTerrain.removeFromParent();
                existingTerrain.removeControl(TerrainLodControl.class);
                existingTerrain.detachAllChildren();
                this.terrain = null;
            }
            File f = new File("terrainsave.jme");
            fis = new FileInputStream(f);
            BinaryImporter imp = BinaryImporter.getInstance();
            imp.setAssetManager(this.assetManager);
            this.terrain = (TerrainQuad)imp.load((InputStream)new BufferedInputStream(fis));
            this.rootNode.attachChild((Spatial)((Node)this.terrain));
            float duration = (float)(System.currentTimeMillis() - start) / 1000.0f;
            System.out.println("Load took " + duration + " seconds");
            TerrainLodControl lodControl = (TerrainLodControl)((Node)this.terrain).getControl(TerrainLodControl.class);
            if (lodControl != null) {
                lodControl.setCamera(this.getCamera());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TerrainTestReadWrite.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(TerrainTestReadWrite.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void testHeightmapBuilding() {
        int i;
        int j;
        int i2;
        int s = 9;
        int b = 3;
        float[] hm = new float[s * s];
        for (i2 = 0; i2 < s; ++i2) {
            for (j = 0; j < s; ++j) {
                hm[i2 * s + j] = i2 * j;
            }
        }
        for (i2 = 0; i2 < s; ++i2) {
            for (j = 0; j < s; ++j) {
                System.out.print(hm[i2 * s + j] + " ");
            }
            System.out.println("");
        }
        TerrainQuad terrain = new TerrainQuad("terrain", b, s, hm);
        float[] hm2 = terrain.getHeightMap();
        boolean failed = false;
        for (i = 0; i < s * s; ++i) {
            if (hm[i] == hm2[i]) continue;
            failed = true;
        }
        System.out.println("");
        if (failed) {
            System.out.println("Terrain heightmap building FAILED!!!");
            for (i = 0; i < s; ++i) {
                for (int j2 = 0; j2 < s; ++j2) {
                    System.out.print(hm2[i * s + j2] + " ");
                }
                System.out.println("");
            }
        } else {
            System.out.println("Terrain heightmap building PASSED");
        }
    }
}

