/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Event;
import com.fluendo.jst.Sink;
import com.fluendo.jst.SystemClock;
import com.fluendo.jst.WaitStatus;
import com.fluendo.utils.Debug;

public abstract class AudioSink
extends Sink
implements ClockProvider {
    protected RingBuffer ringBuffer = null;
    private AudioClock audioClock = new AudioClock();

    public Clock provideClock() {
        return this.audioClock;
    }

    public boolean test() {
        return true;
    }

    protected WaitStatus doSync(long time) {
        return WaitStatus.newOK();
    }

    protected boolean doEvent(Event event) {
        switch (event.getType()) {
            case 1: {
                this.ringBuffer.setFlushing(true);
                break;
            }
            case 2: {
                this.ringBuffer.setFlushing(false);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.drain();
            }
        }
        return true;
    }

    protected int render(Buffer buf) {
        long time;
        if (buf.isFlagSet(1)) {
            this.ringBuffer.nextSample = -1L;
        }
        if ((time = buf.timestamp - this.segStart) < 0L) {
            return 0;
        }
        long sample = (time += this.baseTime) * (long)this.ringBuffer.rate / 1000000L;
        this.ringBuffer.commit(buf.data, sample, buf.offset, buf.length);
        return 0;
    }

    protected boolean setCapsFunc(Caps caps) {
        this.ringBuffer.release();
        boolean res = this.ringBuffer.acquire(caps);
        return res;
    }

    protected int changeState(int transition) {
        switch (transition) {
            case 18: {
                this.ringBuffer = this.createRingBuffer();
                this.ringBuffer.setFlushing(false);
                break;
            }
            case 35: {
                this.ringBuffer.setAutoStart(true);
                break;
            }
            case 50: {
                this.reset();
                this.ringBuffer.setAutoStart(false);
                this.ringBuffer.pause();
                break;
            }
            case 33: {
                this.ringBuffer.setFlushing(true);
            }
        }
        int result = super.changeState(transition);
        switch (transition) {
            case 33: {
                this.ringBuffer.release();
            }
        }
        return result;
    }

    protected void drain() {
        if (this.ringBuffer.rate <= 0) {
            return;
        }
        if (!this.ringBuffer.isAcquired()) {
            return;
        }
        if (this.ringBuffer.getState() != 3) {
            this.ringBuffer.play();
        }
        if (this.ringBuffer.nextSample != -1L) {
            long time = this.ringBuffer.nextSample * 1000000L / (long)this.ringBuffer.rate;
            Clock.ClockID id = this.audioClock.newSingleShotID(time);
            Debug.log(4, this + " waiting until t=" + (double)time / 1000000.0 + "s for playback to finish");
            id.waitID();
            this.ringBuffer.nextSample = -1L;
        }
    }

    protected abstract RingBuffer createRingBuffer();

    protected abstract boolean open(RingBuffer var1);

    protected abstract boolean close(RingBuffer var1);

    protected abstract int write(byte[] var1, int var2, int var3);

    protected abstract long delay();

    protected abstract void reset();

    protected class RingBuffer
    implements Runnable {
        protected byte[] buffer;
        private int state;
        private Thread thread;
        private long nextSample;
        private boolean flushing;
        private boolean autoStart;
        private boolean opened;
        private static final int STOP = 0;
        private static final int PAUSE = 1;
        private static final int PLAY = 2;
        public int bps;
        public int sps;
        public byte[] emptySeg;
        public long playSeg;
        public int segTotal;
        public int segSize;
        public int rate;
        public int channels;

        protected RingBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean running = true;
            while (running) {
                int ret;
                RingBuffer ringBuffer = this;
                synchronized (ringBuffer) {
                    if (this.state != 2) {
                        while (this.state == 1) {
                            try {
                                this.notifyAll();
                                this.wait();
                            }
                            catch (InterruptedException ie) {}
                        }
                        if (this.state == 0) {
                            running = false;
                            break;
                        }
                    }
                }
                int segNum = (int)(this.playSeg % (long)this.segTotal);
                int index = segNum * this.segSize;
                for (int toWrite = this.segSize; toWrite > 0 && (ret = AudioSink.this.write(this.buffer, index, this.segSize)) != -1; toWrite -= ret) {
                }
                this.clear(segNum);
                RingBuffer ringBuffer2 = this;
                synchronized (ringBuffer2) {
                    ++this.playSeg;
                    this.notifyAll();
                }
            }
        }

        public synchronized void setFlushing(boolean flushing) {
            this.flushing = flushing;
            this.clearAll();
            if (flushing) {
                this.pause();
            }
        }

        protected void startWriteThread() {
            this.thread = new Thread((Runnable)this, "cortado-audiosink-ringbuffer");
            this.thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized boolean acquire(Caps caps) {
            if (this.thread != null) {
                return false;
            }
            if (this.opened) {
                return false;
            }
            String mime = caps.getMime();
            if (!mime.equals("audio/raw")) {
                return false;
            }
            this.rate = caps.getFieldInt("rate", 44100);
            this.channels = caps.getFieldInt("channels", 1);
            this.bps = 2 * this.channels;
            boolean res = AudioSink.this.open(this);
            if (!res) {
                return res;
            }
            this.opened = true;
            Debug.log(3, "audio: segSize: " + this.segSize);
            Debug.log(3, "audio: segTotal: " + this.segTotal);
            ++this.segTotal;
            this.buffer = new byte[this.segSize * this.segTotal];
            this.sps = this.segSize / this.bps;
            this.state = 1;
            this.nextSample = 0L;
            this.playSeg = 0L;
            this.startWriteThread();
            return res;
        }

        public synchronized boolean isAcquired() {
            return this.opened;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean release() {
            this.stop();
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                if (this.opened && !AudioSink.this.close(this)) {
                    return false;
                }
                this.opened = false;
            }
            return true;
        }

        private synchronized boolean waitSegment() {
            if (this.flushing) {
                return false;
            }
            if (this.state != 2 && this.autoStart) {
                this.play();
            }
            try {
                if (this.state != 2) {
                    return false;
                }
                this.wait();
                if (this.flushing) {
                    return false;
                }
                if (this.state != 2) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int commit(byte[] data, long sample, int offset, int len) {
            if (sample == -1L) {
                sample = this.nextSample;
            }
            if (sample < 0L) {
                return len;
            }
            if (this.nextSample != -1L) {
                if (Math.abs(sample - this.nextSample) < (long)(this.rate / 10)) {
                    sample = this.nextSample;
                } else {
                    System.out.println("discont: found " + sample + " expected " + this.nextSample);
                }
            }
            int idx = 0;
            this.nextSample = sample + (long)(len / this.bps);
            while (len > 0) {
                int writeOff;
                long writeSeg;
                long diff;
                int writeLen;
                block12: {
                    writeLen = 0;
                    diff = -1L;
                    writeSeg = sample / (long)this.sps;
                    writeOff = (int)(sample % (long)this.sps * (long)this.bps);
                    do {
                        RingBuffer ringBuffer = this;
                        synchronized (ringBuffer) {
                            diff = writeSeg - this.playSeg;
                        }
                        if (diff < 0L) {
                            writeLen = Math.min(this.segSize, len);
                            break block12;
                        }
                        if (diff < (long)this.segTotal) break block12;
                    } while (this.waitSegment());
                    return -1;
                }
                if (diff >= 0L) {
                    int writeSegRel = (int)(writeSeg % (long)this.segTotal);
                    writeLen = Math.min(this.segSize - writeOff, len);
                    System.arraycopy(data, idx, this.buffer, writeSegRel * this.segSize + writeOff, writeLen);
                }
                len -= writeLen;
                idx += writeLen;
                sample += (long)(writeLen / this.bps);
            }
            return len;
        }

        public long samplesPlayed() {
            long delay = AudioSink.this.delay();
            long seg = Math.max(0L, this.playSeg - 1L);
            long samples = seg * (long)this.sps;
            samples = samples >= delay ? (samples -= delay) : 0L;
            return samples;
        }

        public synchronized void clear(long segNum) {
            int index = (int)(segNum % (long)this.segTotal) * this.segSize;
            System.arraycopy(this.emptySeg, 0, this.buffer, index, this.segSize);
        }

        public synchronized void clearAll() {
            for (int i = 0; i < this.segTotal; ++i) {
                this.clear(i);
            }
        }

        public synchronized void setSample(long sample) {
            if (sample == -1L) {
                sample = 0L;
            }
            this.playSeg = sample / (long)this.sps;
            this.nextSample = sample;
            this.clearAll();
        }

        public synchronized void setAutoStart(boolean start) {
            this.autoStart = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean play() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                if (this.flushing) {
                    return false;
                }
                this.state = 2;
                AudioSink.this.audioClock.setStarted(true);
                this.notifyAll();
            }
            Debug.log(4, this + " playing");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pause() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                Debug.log(4, this + " pausing");
                this.state = 1;
                AudioSink.this.audioClock.setStarted(false);
                this.notifyAll();
                if (this.thread != null) {
                    try {
                        Debug.log(4, this + " waiting for pause");
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Debug.log(4, this + " paused");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                Debug.log(4, this + " stopping");
                this.state = 0;
                AudioSink.this.audioClock.setStarted(false);
                this.notifyAll();
            }
            if (this.thread != null) {
                try {
                    Debug.log(4, this + " joining thread");
                    this.thread.join();
                    this.thread = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Debug.log(4, this + " stopped");
            return true;
        }

        public synchronized int getState() {
            return this.state;
        }
    }

    private class AudioClock
    extends SystemClock {
        private long lastTime = -1L;
        private long diff = -1L;
        private boolean started = false;

        private AudioClock() {
        }

        public void setStarted(boolean s) {
            this.started = s;
            if (this.started) {
                this.diff = -1L;
                this.lastTime = -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getInternalTime() {
            long result;
            RingBuffer ringBuffer = AudioSink.this.ringBuffer;
            synchronized (ringBuffer) {
                if (AudioSink.this.ringBuffer == null || AudioSink.this.ringBuffer.rate == 0) {
                    return 0L;
                }
                long samples = AudioSink.this.ringBuffer.samplesPlayed();
                long timePos = samples * 1000000L / (long)AudioSink.this.ringBuffer.rate;
                if (this.started) {
                    long now = System.currentTimeMillis() * 1000L;
                    if (this.diff == -1L) {
                        this.diff = now;
                    }
                    if (timePos != this.lastTime) {
                        this.lastTime = timePos;
                        this.diff = now - timePos;
                    }
                    result = now - this.diff;
                } else {
                    result = timePos;
                }
            }
            return result;
        }
    }
}

