/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PositionTrack
extends AbstractCinematicEvent {
    private static final Logger log = Logger.getLogger(PositionTrack.class.getName());
    private Vector3f startPosition;
    private Vector3f endPosition;
    private Spatial spatial;
    private String spatialName = "";
    private float value = 0.0f;

    public PositionTrack() {
    }

    public PositionTrack(Spatial spatial, Vector3f endPosition) {
        this.endPosition = endPosition;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        if (this.spatial == null) {
            this.spatial = cinematic.getScene().getChild(this.spatialName);
            if (this.spatial != null) {
                log.log(Level.WARNING, "spatial {0} not found in the scene", this.spatialName);
            }
        }
    }

    public PositionTrack(Spatial spatial, Vector3f endPosition, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.endPosition = endPosition;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public PositionTrack(Spatial spatial, Vector3f endPosition, LoopMode loopMode) {
        super(loopMode);
        this.endPosition = endPosition;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public PositionTrack(Spatial spatial, Vector3f endPosition, float initialDuration) {
        super(initialDuration);
        this.endPosition = endPosition;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public void onPlay() {
        if (this.playState != PlayState.Paused) {
            this.startPosition = this.spatial.getWorldTranslation().clone();
        }
        if (this.duration == 0.0f && this.spatial != null) {
            this.spatial.setLocalTranslation(this.endPosition);
        }
    }

    public void onUpdate(float tpf) {
        if (this.spatial != null) {
            this.value += Math.min(tpf * this.speed / this.duration, 1.0f);
            Vector3f pos = FastMath.interpolateLinear(this.value, this.startPosition, this.endPosition);
            this.spatial.setLocalTranslation(pos);
        }
    }

    public void onStop() {
        this.value = 0.0f;
    }

    public void onPause() {
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.spatialName, "spatialName", "");
        oc.write(this.endPosition, "endPosition", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.spatialName = ic.readString("spatialName", "");
        this.endPosition = (Vector3f)ic.readSavable("endPosition", null);
    }
}

