/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderKey;
import com.jme3.shader.Uniform;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Technique
implements Savable {
    private static final Logger logger = Logger.getLogger(Technique.class.getName());
    private TechniqueDef def;
    private Material owner;
    private ArrayList<Uniform> worldBindUniforms;
    private DefineList defines;
    private Shader shader;
    private boolean needReload = true;

    public Technique(Material owner, TechniqueDef def) {
        this.owner = owner;
        this.def = def;
        if (def.isUsingShaders()) {
            this.worldBindUniforms = new ArrayList();
            this.defines = new DefineList();
        }
    }

    public Technique() {
    }

    public TechniqueDef getDef() {
        return this.def;
    }

    public Shader getShader() {
        return this.shader;
    }

    public List<Uniform> getWorldBindUniforms() {
        return this.worldBindUniforms;
    }

    void notifySetParam(String paramName, VarType type, Object value) {
        String defineName = this.def.getShaderParamDefine(paramName);
        if (defineName != null) {
            this.defines.set(defineName, type, value);
            this.needReload = true;
        }
        if (this.shader != null) {
            this.updateUniformParam(paramName, type, value);
        }
    }

    void notifyClearParam(String paramName) {
        String defineName = this.def.getShaderParamDefine(paramName);
        if (defineName != null) {
            this.defines.remove(defineName);
            this.needReload = true;
        }
        if (this.shader != null) {
            if (!paramName.startsWith("m_")) {
                paramName = "m_" + paramName;
            }
            this.shader.removeUniform(paramName);
        }
    }

    void updateUniformParam(String paramName, VarType type, Object value, boolean ifNotOwner) {
        Uniform u = this.shader.getUniform(paramName);
        switch (type) {
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureCubeMap: 
            case Int: {
                u.setValue(VarType.Int, value);
                break;
            }
            default: {
                u.setValue(type, value);
            }
        }
    }

    void updateUniformParam(String paramName, VarType type, Object value) {
        this.updateUniformParam(paramName, type, value, false);
    }

    public boolean isNeedReload() {
        return this.needReload;
    }

    public void makeCurrent(AssetManager assetManager) {
        if (this.def.isUsingShaders()) {
            DefineList newDefines = new DefineList();
            Collection<MatParam> params = this.owner.getParams();
            for (MatParam param : params) {
                String defineName = this.def.getShaderParamDefine(param.getName());
                if (defineName == null) continue;
                newDefines.set(defineName, param.getVarType(), param.getValue());
            }
            if (!this.needReload && this.defines.getCompiled().equals(newDefines.getCompiled())) {
                newDefines = null;
            } else {
                this.defines.clear();
                this.defines.addFrom(newDefines);
                this.loadShader(assetManager);
            }
        }
    }

    private void loadShader(AssetManager manager) {
        DefineList allDefines = new DefineList();
        allDefines.addFrom(this.def.getShaderPresetDefines());
        allDefines.addFrom(this.defines);
        ShaderKey key = new ShaderKey(this.def.getVertexShaderName(), this.def.getFragmentShaderName(), allDefines, this.def.getShaderLanguage());
        this.shader = manager.loadShader(key);
        if (this.shader == null) {
            logger.warning("Failed to reload shader!");
            return;
        }
        this.worldBindUniforms.clear();
        for (UniformBinding binding : this.def.getWorldBindings()) {
            Uniform uniform = this.shader.getUniform("g_" + binding.name());
            uniform.setBinding(binding);
            if (uniform == null) continue;
            this.worldBindUniforms.add(uniform);
        }
        this.needReload = false;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.def, "def", null);
        oc.writeSavableArrayList(this.worldBindUniforms, "worldBindUniforms", null);
        oc.write(this.defines, "defines", null);
        oc.write(this.shader, "shader", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.def = (TechniqueDef)ic.readSavable("def", null);
        this.worldBindUniforms = ic.readSavableArrayList("worldBindUniforms", null);
        this.defines = (DefineList)ic.readSavable("defines", null);
        this.shader = (Shader)ic.readSavable("shader", null);
    }
}

