/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonPoints;
import com.jme3.scene.debug.SkeletonWire;
import com.jme3.scene.shape.Box;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import projectkyoto.jme3.mmd.PMDBoneMarkControl;
import projectkyoto.jme3.mmd.PMDGeometry;
import projectkyoto.jme3.mmd.PMDMesh;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.PMDSkinMesh;
import projectkyoto.jme3.mmd.SkeletonControl;
import projectkyoto.jme3.mmd.Skin;
import projectkyoto.mmd.file.PMDBone;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDSkinData;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.MeshConverter;
import projectkyoto.mmd.file.util2.MeshData;

public class PMDLoaderGLSLSkinning2
implements AssetLoader {
    PMDModel model;
    PMDNode node;
    MeshConverter meshConverter;
    int meshCount = 1;
    AssetManager assetManager;
    String folderName;
    List<PMDMesh> meshList = new ArrayList<PMDMesh>();
    List<PMDSkinMesh> skinMeshList = new ArrayList<PMDSkinMesh>();
    VertexBuffer skinvb;
    VertexBuffer skinvb2;
    VertexBuffer skinnb;
    VertexBuffer skinnb2;
    VertexBuffer skintb;
    Skin[] skinArray;
    SkeletonControl skeletonControl;

    public PMDLoaderGLSLSkinning2() {
    }

    public PMDLoaderGLSLSkinning2(AssetManager assetManager, PMDModel model) {
        this.assetManager = assetManager;
        this.model = model;
        this.folderName = "/Model/";
    }

    public void init() {
        this.node = null;
        this.meshConverter = new MeshConverter(this.model);
        this.meshCount = 1;
        this.meshList.clear();
        this.skinMeshList.clear();
        this.skinvb = null;
        this.skinvb2 = null;
        this.skinnb = null;
        this.skinnb2 = null;
        this.skintb = null;
        this.skeletonControl = null;
        this.skinArray = null;
    }

    public PMDNode createNode(String name) {
        PMDGeometry geom;
        Mesh mesh;
        this.init();
        this.node = new PMDNode(name, this.model, this.assetManager);
        this.meshCount = 1;
        this.meshConverter.convertMesh();
        System.out.println("child size = " + this.node.getChildren().size() + " " + this.meshList.size() + " " + this.skinMeshList.size());
        for (MeshData md : this.meshConverter.getMeshDataList()) {
            mesh = this.createMesh(md);
            geom = new PMDGeometry("geom" + this.meshCount++);
            geom.setMesh(mesh);
            PMDMaterial pmdMaterial = md.getMaterial();
            this.setupMaterial(pmdMaterial, geom);
            System.out.println(this.node.attachChild((Spatial)geom));
            this.meshList.add((PMDMesh)mesh);
        }
        this.createSkinCommonVertData();
        for (PMDMaterial pmdMaterial : this.meshConverter.getSkinMeshData().getIndexMap().keySet()) {
            mesh = this.createSkinMesh(pmdMaterial);
            geom = new PMDGeometry("geom" + this.meshCount++);
            geom.setMesh(mesh);
            this.setupMaterial(pmdMaterial, geom);
            System.out.println(this.node.attachChild((Spatial)geom));
            this.skinMeshList.add((PMDSkinMesh)mesh);
        }
        System.out.println("child size = " + this.node.getChildren().size() + " " + this.meshList.size() + " " + this.skinMeshList.size());
        this.createSkinArray();
        this.createSkeleton();
        this.node.setSkinData(this.skinMeshList.toArray(new PMDSkinMesh[this.skinMeshList.size()]), this.meshConverter.getSkinMeshData().getVertexList(), this.skinArray);
        this.node.targets = this.meshList.toArray(new PMDMesh[this.meshList.size()]);
        this.node.init();
        this.node.update();
        return this.node;
    }

    void createSkinCommonVertData() {
        this.skinvb = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer skinvfb = BufferUtils.createFloatBuffer((int)(this.meshConverter.getSkinMeshData().getVertexList().size() * 3));
        this.skinvb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)skinvfb);
        this.skinvb2 = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer skinvfb2 = BufferUtils.createFloatBuffer((int)(this.meshConverter.getSkinMeshData().getVertexList().size() * 3));
        this.skinvb2.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)skinvfb2);
        this.skinnb = new VertexBuffer(VertexBuffer.Type.Normal);
        FloatBuffer skinnfb = BufferUtils.createFloatBuffer((int)(this.meshConverter.getSkinMeshData().getVertexList().size() * 3));
        this.skinnb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)skinnfb);
        this.skinnb2 = new VertexBuffer(VertexBuffer.Type.Normal);
        FloatBuffer skinnfb2 = BufferUtils.createFloatBuffer((int)(this.meshConverter.getSkinMeshData().getVertexList().size() * 3));
        this.skinnb2.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)skinnfb2);
        this.skintb = new VertexBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer skintfb = BufferUtils.createFloatBuffer((int)(this.meshConverter.getSkinMeshData().getVertexList().size() * 2));
        this.skintb.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, (Buffer)skintfb);
        for (PMDVertex v : this.meshConverter.getSkinMeshData().getVertexList()) {
            skinvfb.put(v.getPos().x).put(v.getPos().y).put(v.getPos().z);
            skinnfb.put(v.getNormal().x).put(v.getNormal().y).put(v.getNormal().z);
            skintfb.put(v.getUv().getU()).put(1.0f - v.getUv().getV());
        }
        this.skintb.setUpdateNeeded();
    }

    PMDSkinMesh createSkinMesh(PMDMaterial pmdMaterial) {
        PMDSkinMesh mesh = new PMDSkinMesh();
        List<Integer> indexList = this.meshConverter.getSkinMeshData().getIndexMap().get(pmdMaterial);
        mesh.setMode(Mesh.Mode.Triangles);
        mesh.setBuffer(this.skinvb);
        mesh.setSkinvb2(this.skinvb2);
        mesh.setBuffer(this.skinnb);
        mesh.setSkinnb2(this.skinnb2);
        mesh.setBuffer(this.skintb);
        VertexBuffer ib = new VertexBuffer(VertexBuffer.Type.Index);
        ShortBuffer isb = BufferUtils.createShortBuffer((int)indexList.size());
        for (Integer index : indexList) {
            isb.put(index.shortValue());
        }
        ib.setupData(VertexBuffer.Usage.Static, 1, VertexBuffer.Format.UnsignedShort, (Buffer)isb);
        mesh.setBuffer(ib);
        return mesh;
    }

    PMDMesh createMesh(MeshData md) {
        int i;
        PMDMesh mesh = new PMDMesh();
        mesh.setMode(Mesh.Mode.Triangles);
        VertexBuffer vb = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer vfb = BufferUtils.createFloatBuffer((int)(md.getVertexList().size() * 3));
        VertexBuffer nb = new VertexBuffer(VertexBuffer.Type.Normal);
        FloatBuffer nfb = BufferUtils.createFloatBuffer((int)(md.getVertexList().size() * 3));
        VertexBuffer tb = new VertexBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer tfb = BufferUtils.createFloatBuffer((int)(md.getVertexList().size() * 2));
        VertexBuffer wb = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        FloatBuffer wfb = BufferUtils.createFloatBuffer((int)(md.getVertexList().size() * 4));
        VertexBuffer ib = new VertexBuffer(VertexBuffer.Type.Index);
        ShortBuffer isb = BufferUtils.createShortBuffer((int)md.getIndexList().size());
        VertexBuffer bib = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        ShortBuffer bisb = BufferUtils.createShortBuffer((int)(md.getIndexList().size() * 4));
        for (PMDVertex v : md.getVertexList()) {
            vfb.put(v.getPos().x).put(v.getPos().y).put(v.getPos().z);
            nfb.put(v.getNormal().x).put(v.getNormal().y).put(v.getNormal().z);
            tfb.put(v.getUv().getU()).put(1.0f - v.getUv().getV());
            float weight = (float)v.getBoneWeight() / 100.0f;
            wfb.put(weight).put(1.0f - weight).put(0.0f).put(0.0f);
            bisb.put((short)md.getBoneList().indexOf(v.getBoneNum1())).put((short)md.getBoneList().indexOf(v.getBoneNum2())).put((short)0).put((short)0);
        }
        for (Integer index : md.getIndexList()) {
            isb.put(index.shortValue());
        }
        vb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)vfb);
        nb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)nfb);
        tb.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, (Buffer)tfb);
        wb.setupData(VertexBuffer.Usage.Static, 4, VertexBuffer.Format.Float, (Buffer)wfb);
        ib.setupData(VertexBuffer.Usage.Static, 1, VertexBuffer.Format.UnsignedShort, (Buffer)isb);
        bib.setupData(VertexBuffer.Usage.Static, 4, VertexBuffer.Format.Short, (Buffer)bisb);
        mesh.setBuffer(vb);
        mesh.setBuffer(nb);
        mesh.setVbBackup(vb);
        mesh.setNbBackup(nb);
        mesh.setBuffer(tb);
        mesh.setBuffer(wb);
        mesh.setBuffer(ib);
        mesh.setBuffer(bib);
        short[] indexArray = new short[this.meshConverter.getMaxBoneSize()];
        for (i = 0; i < indexArray.length; ++i) {
            indexArray[i] = i < md.getBoneList().size() ? md.getBoneList().get(i).shortValue() : (short)0;
        }
        mesh.setBoneIndexArray(indexArray);
        mesh.setBoneMatrixArray(new Matrix4f[indexArray.length]);
        for (i = 0; i < mesh.getBoneMatrixArray().length; ++i) {
            mesh.getBoneMatrixArray()[i] = new Matrix4f();
            mesh.getBoneMatrixArray()[i].loadIdentity();
        }
        return mesh;
    }

    void setupMaterial(PMDMaterial m, PMDGeometry geom) {
        if (geom.getMesh() instanceof PMDSkinMesh) {
            Material mat = this.createMaterial(m, false);
            geom.setMaterial(mat);
            geom.setGlslSkinningMaterial(mat);
            geom.setNoSkinningMaterial(mat);
        } else {
            Material mat = this.createMaterial(m, true);
            geom.setMaterial(mat);
            geom.setGlslSkinningMaterial(mat);
            mat = this.createMaterial(m, false);
            geom.setNoSkinningMaterial(mat);
        }
        geom.setPmdMaterial(m);
        if (m.getMaterial().getFaceColor().getAlpha() < 1.0f) {
            geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        } else {
            geom.setQueueBucket(RenderQueue.Bucket.Inherit);
        }
    }

    Material createMaterial(PMDMaterial m, boolean skinning) {
        Texture toonTexture;
        Material mat;
        block25: {
            mat = m.getMaterial().getFaceColor().getAlpha() < 1.0f ? (!skinning ? new Material(this.assetManager, "MatDefs/pmd/pmd_no_skinning_alpha.j3md") : new Material(this.assetManager, "MatDefs/pmd/pmd_alpha.j3md")) : (!skinning ? new Material(this.assetManager, "MatDefs/pmd/pmd_no_skinning.j3md") : new Material(this.assetManager, "MatDefs/pmd/pmd.j3md"));
            float alpha = m.getMaterial().getFaceColor().getAlpha();
            if (alpha > 0.99f) {
                alpha = 1.0f;
            }
            ColorRGBA ambientColor = new ColorRGBA(m.getMaterial().getAmbientColor().getRed(), m.getMaterial().getAmbientColor().getGreen(), m.getMaterial().getAmbientColor().getBlue(), alpha);
            ColorRGBA diffuseColor = new ColorRGBA(m.getMaterial().getFaceColor().getRed(), m.getMaterial().getFaceColor().getGreen(), m.getMaterial().getFaceColor().getBlue(), alpha);
            ColorRGBA ambientAndDiffuseColor = ambientColor.add(diffuseColor);
            ambientAndDiffuseColor.multLocal(0.5f);
            ambientAndDiffuseColor.a = alpha;
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Ambient", ambientAndDiffuseColor);
            mat.setColor("Specular", new ColorRGBA(m.getMaterial().getSpecularColor().getRed(), m.getMaterial().getSpecularColor().getGreen(), m.getMaterial().getSpecularColor().getBlue(), alpha));
            mat.setColor("Diffuse", ambientAndDiffuseColor);
            mat.setFloat("Shininess", m.getMaterial().getPower());
            if (m.getTextureFileName().length() > 0) {
                StringTokenizer st = new StringTokenizer(m.getTextureFileName(), "*");
                System.out.println("m.getTextureFileName() = " + m.getTextureFileName());
                while (st.hasMoreElements()) {
                    String fileName = st.nextToken();
                    System.out.println("fileName = " + fileName);
                    String s = fileName.substring(fileName.indexOf(46) + 1);
                    Texture texture = this.assetManager.loadTexture(this.folderName + fileName);
                    s = s.toLowerCase();
                    if (s.equals("spa")) {
                        texture.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                        mat.setTexture("SphereMap_A", texture);
                        continue;
                    }
                    if (s.equals("sph")) {
                        texture.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                        mat.setTexture("SphereMap_H", texture);
                        continue;
                    }
                    mat.setTexture("DiffuseMap", texture);
                }
            }
            byte toonIndex = m.getToonIndex();
            toonTexture = null;
            if (toonIndex >= 0) {
                String extToonName = this.model.getToonTextureList().getToonFileName()[toonIndex];
                try {
                    toonTexture = this.assetManager.loadTexture(this.folderName + extToonName);
                }
                catch (AssetNotFoundException ex) {
                    String toonname = null;
                    switch (toonIndex) {
                        case 0: {
                            toonname = "toon01.bmp";
                            break;
                        }
                        case 1: {
                            toonname = "toon02.bmp";
                            break;
                        }
                        case 2: {
                            toonname = "toon03.bmp";
                            break;
                        }
                        case 3: {
                            toonname = "toon04.bmp";
                            break;
                        }
                        case 4: {
                            toonname = "toon05.bmp";
                            break;
                        }
                        case 5: {
                            toonname = "toon06.bmp";
                            break;
                        }
                        case 6: {
                            toonname = "toon07.bmp";
                            break;
                        }
                        case 7: {
                            toonname = "toon08.bmp";
                            break;
                        }
                        case 8: {
                            toonname = "toon09.bmp";
                            break;
                        }
                        case 9: {
                            toonname = "toon10.bmp";
                        }
                    }
                    if (toonname == null) break block25;
                    toonTexture = this.assetManager.loadTexture("toon/" + toonname);
                }
            }
        }
        if (toonTexture != null) {
            toonTexture.setWrap(Texture.WrapAxis.S, Texture.WrapMode.EdgeClamp);
            toonTexture.setWrap(Texture.WrapAxis.T, Texture.WrapMode.EdgeClamp);
            mat.setTexture("ColorRamp", toonTexture);
        }
        if (m.getEdgeFlag() != 0) {
            mat.setFloat("EdgeSize", 0.01f);
        } else {
            mat.setFloat("EdgeSize", 0.0f);
        }
        if (m.getMaterial().getFaceColor().getAlpha() < 1.0f) {
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            mat.getAdditionalRenderState().setAlphaTest(true);
        } else {
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            mat.getAdditionalRenderState().setAlphaTest(true);
        }
        return mat;
    }

    void createSkeleton() {
        Bone bone;
        TempVars temp = TempVars.get();
        Bone[] boneArray = new Bone[this.model.getBoneList().getBoneCount()];
        int boneIndex = 0;
        for (PMDBone pmdBone : this.model.getBoneList().getBones()) {
            bone = new Bone(pmdBone.getBoneName());
            bone.setUserControl(true);
            Vector3f translation = new Vector3f(pmdBone.getBoneHeadPos().x, pmdBone.getBoneHeadPos().y, pmdBone.getBoneHeadPos().z);
            Quaternion rotation = new Quaternion();
            boneArray[boneIndex++] = bone;
        }
        boneIndex = 0;
        for (PMDBone pmdBone : this.model.getBoneList().getBones()) {
            bone = boneArray[boneIndex];
            if (pmdBone.getParentBoneIndex() < boneArray.length) {
                Bone parent = boneArray[pmdBone.getParentBoneIndex()];
                PMDBone parentPMDBone = this.model.getBoneList().getBones()[pmdBone.getParentBoneIndex()];
                parent.addChild(bone);
                Vector3f v1 = temp.vect1;
                Vector3f v2 = temp.vect2;
                v1.set(pmdBone.getBoneHeadPos().x, pmdBone.getBoneHeadPos().y, pmdBone.getBoneHeadPos().z);
                v2.set(parentPMDBone.getBoneHeadPos().x, parentPMDBone.getBoneHeadPos().y, parentPMDBone.getBoneHeadPos().z);
                v1.subtractLocal(v2);
                bone.setBindTransforms(v1, Quaternion.IDENTITY, new Vector3f(1.0f, 1.0f, 1.0f));
            } else {
                Vector3f v1 = temp.vect1;
                v1.set(pmdBone.getBoneHeadPos().x, pmdBone.getBoneHeadPos().y, pmdBone.getBoneHeadPos().z);
                bone.setBindTransforms(v1, Quaternion.IDENTITY, new Vector3f(1.0f, 1.0f, 1.0f));
            }
            ++boneIndex;
        }
        Skeleton skeleton = new Skeleton(boneArray);
        PMDMesh[] meshes = this.meshList.toArray(new PMDMesh[this.meshList.size()]);
        Quaternion q = new Quaternion();
        q = q.fromAngleNormalAxis(0.3926991f, new Vector3f(0.0f, 0.0f, 1.0f));
        this.node.skeleton = skeleton;
        temp.release();
    }

    void createSkinArray() {
        ArrayList<Skin> skinList = new ArrayList<Skin>();
        for (int i = 0; i < this.model.getSkinCount(); ++i) {
            PMDSkinData pmdSkinData = this.model.getSkinData()[i];
            if (pmdSkinData.getSkinType() == 0) continue;
            Skin skin = new Skin(this.node, pmdSkinData.getSkinName());
            skin.setSkinData(pmdSkinData);
            skinList.add(skin);
        }
        this.skinArray = skinList.toArray(new Skin[skinList.size()]);
    }

    public Node createBoneNode() {
        Node boneNode = new Node("boneMarks");
        Spatial[] boneMarkArray = new Spatial[this.model.getBoneList().getBoneCount()];
        for (int i = 0; i < this.model.getBoneList().getBoneCount(); ++i) {
            PMDBone bone = this.model.getBoneList().getBones()[i];
            PMDGeometry boneMark = new PMDGeometry(bone.getBoneName());
            Node boneMarkNode = new Node();
            boneMark.setMesh((Mesh)new Box(4.0f, 4.0f, 0.1f));
            boneMarkArray[i] = boneMarkNode;
            Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setColor("Color", ColorRGBA.Blue);
            boneMark.setMaterial(mat);
            boneMarkNode.attachChild((Spatial)boneMark);
            boneNode.attachChild((Spatial)boneMarkNode);
        }
        PMDBoneMarkControl bmc = new PMDBoneMarkControl(this.skeletonControl, boneMarkArray, this.model.getBoneList().getBones());
        this.node.addControl((Control)bmc);
        PMDGeometry skeletonGeom = new PMDGeometry();
        SkeletonPoints sp = new SkeletonPoints(this.skeletonControl.skeleton);
        skeletonGeom.setMesh((Mesh)sp);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Green);
        mat.getAdditionalRenderState().setDepthTest(false);
        skeletonGeom.setMaterial(mat);
        this.node.attachChild((Spatial)skeletonGeom);
        SkeletonWire sw = new SkeletonWire(this.skeletonControl.skeleton);
        PMDGeometry skeletonWireGeom = new PMDGeometry("skeletonWire", (Mesh)sw);
        this.node.attachChild((Spatial)skeletonWireGeom);
        skeletonWireGeom.setMaterial(mat);
        sp.updateGeometry();
        sw.updateGeometry();
        return boneNode;
    }

    public Object load(AssetInfo ai) throws IOException {
        boolean errFlag = false;
        while (true) {
            try {
                this.assetManager = ai.getManager();
                this.model = new PMDModel(ai.openStream());
                this.folderName = ai.getKey().getFolder();
                this.meshConverter = new MeshConverter(this.model);
                PMDNode pmdNode = this.createNode(ai.getKey().getName());
                pmdNode.setGlslSkinning(false);
                return pmdNode;
            }
            catch (OutOfMemoryError ex) {
                if (errFlag) {
                    throw new RuntimeException(ex);
                }
                errFlag = true;
                System.gc();
                continue;
            }
            break;
        }
    }
}

