/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.NativeMeshUtil;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeshCollisionShape
extends CollisionShape {
    protected int numVertices;
    protected int numTriangles;
    protected int vertexStride;
    protected int triangleIndexStride;
    protected ByteBuffer triangleIndexBase;
    protected ByteBuffer vertexBase;
    protected long meshId = 0L;

    public MeshCollisionShape() {
    }

    public MeshCollisionShape(Mesh mesh) {
        this.createCollisionMesh(mesh);
    }

    private void createCollisionMesh(Mesh mesh) {
        int n;
        this.triangleIndexBase = ByteBuffer.allocateDirect(mesh.getTriangleCount() * 3 * 4).order(ByteOrder.nativeOrder());
        this.vertexBase = ByteBuffer.allocateDirect(mesh.getVertexCount() * 3 * 4).order(ByteOrder.nativeOrder());
        this.numVertices = mesh.getVertexCount();
        this.vertexStride = 12;
        this.numTriangles = mesh.getTriangleCount();
        this.triangleIndexStride = 12;
        IndexBuffer indexBuffer = mesh.getIndexBuffer();
        FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        floatBuffer.rewind();
        int n2 = mesh.getVertexCount() * 3;
        for (n = 0; n < n2; ++n) {
            float f = floatBuffer.get();
            this.vertexBase.putFloat(f);
        }
        n = mesh.getTriangleCount() * 3;
        for (int i = 0; i < n; ++i) {
            this.triangleIndexBase.putInt(indexBuffer.get(i));
        }
        floatBuffer.rewind();
        floatBuffer.clear();
        this.createShape();
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.numVertices, "numVertices", 0);
        outputCapsule.write(this.numTriangles, "numTriangles", 0);
        outputCapsule.write(this.vertexStride, "vertexStride", 0);
        outputCapsule.write(this.triangleIndexStride, "triangleIndexStride", 0);
        outputCapsule.write(this.triangleIndexBase.array(), "triangleIndexBase", new byte[0]);
        outputCapsule.write(this.vertexBase.array(), "vertexBase", new byte[0]);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.numVertices = inputCapsule.readInt("numVertices", 0);
        this.numTriangles = inputCapsule.readInt("numTriangles", 0);
        this.vertexStride = inputCapsule.readInt("vertexStride", 0);
        this.triangleIndexStride = inputCapsule.readInt("triangleIndexStride", 0);
        this.triangleIndexBase = ByteBuffer.wrap(inputCapsule.readByteArray("triangleIndexBase", new byte[0]));
        this.vertexBase = ByteBuffer.wrap(inputCapsule.readByteArray("vertexBase", new byte[0])).order(ByteOrder.nativeOrder());
        this.createShape();
    }

    protected void createShape() {
        this.meshId = NativeMeshUtil.createTriangleIndexVertexArray(this.triangleIndexBase, this.vertexBase, this.numTriangles, this.numVertices, this.vertexStride, this.triangleIndexStride);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Mesh {0}", Long.toHexString(this.meshId));
        this.objectId = this.createShape(this.meshId);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(long var1);

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Finalizing Mesh {0}", Long.toHexString(this.meshId));
        this.finalizeNative(this.meshId);
    }

    private native void finalizeNative(long var1);
}

