/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.PowerLineFrequency;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class AntiFlickerCapability
extends CapabilityBase {
    private StateChangedObservable powerLineFrequencyChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), hCallback);
        }
    };

    public AntiFlickerCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    public PowerLineFrequency getPowerLineFrequency() {
        return PowerLineFrequency.fromNative(NativeMethods.xnGetPowerLineFrequency(this.toNative()));
    }

    public void setPowerLineFrequency(PowerLineFrequency frequency) throws StatusException {
        int status = NativeMethods.xnSetPowerLineFrequency(this.toNative(), frequency.toNative());
        WrapperUtils.throwOnError(status);
    }

    public IStateChangedObservable getPowerLineFrequencyChangedEvent() {
        return this.powerLineFrequencyChanged;
    }
}

