/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.Cropping;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class CroppingCapability
extends CapabilityBase {
    private StateChangedObservable croppingChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToCroppingChange(CroppingCapability.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromCroppingChange(CroppingCapability.this.toNative(), hCallback);
        }
    };

    public CroppingCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    public void setCropping(Cropping cropping) throws StatusException {
        int status = NativeMethods.xnSetCropping(this.toNative(), cropping.getXOffset(), cropping.getYOffset(), cropping.getXSize(), cropping.getYSize(), cropping.isEnabled());
        WrapperUtils.throwOnError(status);
    }

    public Cropping getCropping() throws StatusException {
        OutArg<Integer> xOffset = new OutArg<Integer>();
        OutArg<Integer> yOffset = new OutArg<Integer>();
        OutArg<Integer> xSize = new OutArg<Integer>();
        OutArg<Integer> ySize = new OutArg<Integer>();
        OutArg<Boolean> isEnabled = new OutArg<Boolean>();
        int status = NativeMethods.xnGetCropping(this.toNative(), xOffset, yOffset, xSize, ySize, isEnabled);
        WrapperUtils.throwOnError(status);
        return new Cropping((Integer)xOffset.value, (Integer)yOffset.value, (Integer)xSize.value, (Integer)ySize.value, (Boolean)isEnabled.value);
    }

    public IStateChangedObservable getCroppingChangedEvent() {
        return this.croppingChanged;
    }
}

