/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.Generator;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class FrameSyncCapability
extends CapabilityBase {
    private StateChangedObservable frameSyncChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToFrameSyncChange(FrameSyncCapability.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromFrameSyncChange(FrameSyncCapability.this.toNative(), hCallback);
        }
    };

    public FrameSyncCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    boolean canFrameSyncWith(Generator other) {
        return NativeMethods.xnCanFrameSyncWith(this.toNative(), other.toNative());
    }

    void frameSyncWith(Generator other) throws StatusException {
        int status = NativeMethods.xnFrameSyncWith(this.toNative(), other.toNative());
        WrapperUtils.throwOnError(status);
    }

    void stopFrameSyncWith(Generator other) throws StatusException {
        int status = NativeMethods.xnStopFrameSyncWith(this.toNative(), other.toNative());
        WrapperUtils.throwOnError(status);
    }

    boolean isFrameSyncedWith(Generator other) {
        return NativeMethods.xnIsFrameSyncedWith(this.toNative(), other.toNative());
    }

    public IStateChangedObservable getFrameSyncChangedEvent() {
        return this.frameSyncChanged;
    }
}

