/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.ActiveHandEventArgs;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.HandTouchingFOVEdgeCapability;
import org.OpenNI.IObservable;
import org.OpenNI.InactiveHandEventArgs;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class HandsGenerator
extends Generator {
    private Observable<ActiveHandEventArgs> handCreateEvent = new Observable<ActiveHandEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, "callback", null, null, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), hCallback);
        }

        public void callback(int id, Point3D point, float time) {
            this.notify(new ActiveHandEventArgs(id, point, time));
        }
    };
    private Observable<ActiveHandEventArgs> handUpdateEvent = new Observable<ActiveHandEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, null, "callback", null, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), hCallback);
        }

        public void callback(int id, Point3D point, float time) {
            this.notify(new ActiveHandEventArgs(id, point, time));
        }
    };
    private Observable<InactiveHandEventArgs> handDestroyEvent = new Observable<InactiveHandEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, null, null, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), hCallback);
        }

        public void callback(int id, float time) {
            this.notify(new InactiveHandEventArgs(id, time));
        }
    };

    HandsGenerator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static HandsGenerator create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateHandsGenerator(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        HandsGenerator result = (HandsGenerator)context.createProductionNodeObject((Long)handle.value, NodeType.HANDS);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static HandsGenerator create(Context context, Query query) throws GeneralException {
        return HandsGenerator.create(context, query, null);
    }

    public static HandsGenerator create(Context context) throws GeneralException {
        return HandsGenerator.create(context, null, null);
    }

    public void StopTracking(int id) throws StatusException {
        int status = NativeMethods.xnStopTracking(this.toNative(), id);
        WrapperUtils.throwOnError(status);
    }

    public void StopTrackingAll() throws StatusException {
        int status = NativeMethods.xnStopTrackingAll(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void StartTracking(Point3D position) throws StatusException {
        int status = NativeMethods.xnStartTracking(this.toNative(), position.getX(), position.getY(), position.getZ());
        WrapperUtils.throwOnError(status);
    }

    public void SetSmoothing(float factor) throws StatusException {
        int status = NativeMethods.xnSetTrackingSmoothing(this.toNative(), factor);
        WrapperUtils.throwOnError(status);
    }

    public HandTouchingFOVEdgeCapability getHandTouchingFOVEdgeCapability() throws StatusException {
        return new HandTouchingFOVEdgeCapability(this);
    }

    public IObservable<ActiveHandEventArgs> getHandCreateEvent() {
        return this.handCreateEvent;
    }

    public IObservable<ActiveHandEventArgs> getHandUpdateEvent() {
        return this.handUpdateEvent;
    }

    public IObservable<InactiveHandEventArgs> getHandDestroyEvent() {
        return this.handDestroyEvent;
    }
}

