/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.ImageMap;
import org.OpenNI.ImageMetaData;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.PixelFormat;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class ImageGenerator
extends MapGenerator {
    private ImageMap currImageMap;
    private int currImageMapFrameID;
    private StateChangedObservable pixelFormatChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToPixelFormatChange(ImageGenerator.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromPixelFormatChange(ImageGenerator.this.toNative(), hCallback);
        }
    };

    ImageGenerator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static ImageGenerator create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateImageGenerator(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        ImageGenerator result = (ImageGenerator)context.createProductionNodeObject((Long)handle.value, NodeType.IMAGE);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static ImageGenerator create(Context context, Query query) throws GeneralException {
        return ImageGenerator.create(context, query, null);
    }

    public static ImageGenerator create(Context context) throws GeneralException {
        return ImageGenerator.create(context, null, null);
    }

    public boolean isPixelFormatSupported(PixelFormat format) {
        return NativeMethods.xnIsPixelFormatSupported(this.toNative(), format.toNative());
    }

    public void setPixelFormat(PixelFormat format) throws StatusException {
        int status = NativeMethods.xnSetPixelFormat(this.toNative(), format.toNative());
        WrapperUtils.throwOnError(status);
    }

    public PixelFormat getPixelFormat() {
        return PixelFormat.fromNative(NativeMethods.xnGetPixelFormat(this.toNative()));
    }

    public ImageMap getImageMap() throws GeneralException {
        int frameID = this.getFrameID();
        if (this.currImageMap == null || this.currImageMapFrameID != frameID) {
            long ptr = NativeMethods.xnGetImageMap(this.toNative());
            MapOutputMode mode = this.getMapOutputMode();
            this.currImageMap = new ImageMap(ptr, mode.getXRes(), mode.getYRes(), NativeMethods.xnGetBytesPerPixel(this.toNative()));
            this.currImageMapFrameID = frameID;
        }
        return this.currImageMap;
    }

    public IStateChangedObservable getPixelFormatChangedEvent() {
        return this.pixelFormatChanged;
    }

    public void getMetaData(ImageMetaData ImageMD) {
        NativeMethods.xnGetImageMetaData(this.toNative(), ImageMD);
    }

    public ImageMetaData getMetaData() {
        ImageMetaData ImageMD = new ImageMetaData();
        this.getMetaData(ImageMD);
        return ImageMD;
    }
}

