/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfo;
import org.OpenNI.ObjectWrapper;
import org.OpenNI.ProductionNodeDescription;
import org.OpenNI.Query;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class NodeInfoList
extends ObjectWrapper
implements Iterable<NodeInfo> {
    NodeInfoList(long ptr) {
        super(ptr);
    }

    public void add(ProductionNodeDescription description, String creationInfo, NodeInfoList neededNodes) throws StatusException {
        long pNativeDesc = description.createNative();
        int status = NativeMethods.xnNodeInfoListAdd(this.toNative(), pNativeDesc, creationInfo, neededNodes == null ? 0L : neededNodes.toNative());
        ProductionNodeDescription.freeNative(pNativeDesc);
        WrapperUtils.throwOnError(status);
    }

    public void addNode(NodeInfo nodeInfo) throws StatusException {
        int status = NativeMethods.xnNodeInfoListAddNode(this.toNative(), nodeInfo.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void addNodeFromList(Iterator<NodeInfo> current) throws StatusException {
        NodeInfoListIterator iter = (NodeInfoListIterator)current;
        int status = NativeMethods.xnNodeInfoListAddNodeFromList(this.toNative(), iter.it);
        WrapperUtils.throwOnError(status);
    }

    public void remove(Iterator<NodeInfo> location) throws StatusException {
        NodeInfoListIterator iter = (NodeInfoListIterator)location;
        int status = NativeMethods.xnNodeInfoListRemove(this.toNative(), iter.it);
        WrapperUtils.throwOnError(status);
    }

    public void clear() throws StatusException {
        int status = NativeMethods.xnNodeInfoListClear(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void append(NodeInfoList other) throws StatusException {
        int status = NativeMethods.xnNodeInfoListAppend(this.toNative(), other.toNative());
        WrapperUtils.throwOnError(status);
    }

    public boolean isEmpty() {
        return NativeMethods.xnNodeInfoListIsEmpty(this.toNative());
    }

    public void filter(Query query, Context context) throws StatusException {
        int status = NativeMethods.xnNodeQueryFilterList(context.toNative(), query.toNative(), this.toNative());
        WrapperUtils.throwOnError(status);
    }

    @Override
    public Iterator<NodeInfo> iterator() {
        return new NodeInfoListIterator(this.toNative());
    }

    @Override
    protected void freeObject(long ptr) {
        NativeMethods.xnNodeInfoListFree(ptr);
    }

    private class NodeInfoListIterator
    implements Iterator<NodeInfo> {
        protected long it;

        NodeInfoListIterator(long pNodeInfoList) {
            this.it = NativeMethods.xnNodeInfoListGetFirst(pNodeInfoList);
        }

        @Override
        public boolean hasNext() {
            return NativeMethods.xnNodeInfoListIteratorIsValid(this.it);
        }

        @Override
        public NodeInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            NodeInfo next = null;
            try {
                next = new NodeInfo(NativeMethods.xnNodeInfoListGetCurrent(this.it));
            }
            catch (GeneralException generalException) {
                // empty catch block
            }
            this.it = NativeMethods.xnNodeInfoListGetNext(this.it);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

