/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CodecID;
import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.RecordMedium;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Recorder
extends ProductionNode {
    Recorder(Context context, long nodeHandle, boolean addRef) throws StatusException {
        super(context, nodeHandle, addRef);
    }

    public static Recorder create(Context context, String formatName) throws GeneralException {
        OutArg<Long> phRecorder = new OutArg<Long>();
        int status = NativeMethods.xnCreateRecorder(context.toNative(), formatName, phRecorder);
        WrapperUtils.throwOnError(status);
        Recorder recorder = (Recorder)context.createProductionNodeObject((Long)phRecorder.value, NodeType.RECORDER);
        NativeMethods.xnProductionNodeRelease((Long)phRecorder.value);
        return recorder;
    }

    public String getFormat() {
        return NativeMethods.xnGetRecorderFormat(this.toNative());
    }

    public void setDestination(RecordMedium medium, String name) throws StatusException {
        int status = NativeMethods.xnSetRecorderDestination(this.toNative(), medium.toNative(), name);
        WrapperUtils.throwOnError(status);
    }

    public RecordMedium getDestinationMedium() throws StatusException {
        OutArg<Integer> pMedium = new OutArg<Integer>();
        OutArg<String> pDest = new OutArg<String>();
        int status = NativeMethods.xnGetRecorderDestination(this.toNative(), pMedium, pDest);
        WrapperUtils.throwOnError(status);
        return RecordMedium.fromNative((Integer)pMedium.value);
    }

    public String getDestination() throws StatusException {
        OutArg<Integer> pMedium = new OutArg<Integer>();
        OutArg<String> pDest = new OutArg<String>();
        int status = NativeMethods.xnGetRecorderDestination(this.toNative(), pMedium, pDest);
        WrapperUtils.throwOnError(status);
        return (String)pDest.value;
    }

    public void addNodeToRecording(ProductionNode node, CodecID codec) throws StatusException {
        int status = NativeMethods.xnAddNodeToRecording(this.toNative(), node.toNative(), codec.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void addNodeToRecording(ProductionNode node) throws StatusException {
        this.addNodeToRecording(node, CodecID.Null);
    }

    public void removeNodeToRecording(ProductionNode node) throws StatusException {
        int status = NativeMethods.xnRemoveNodeFromRecording(this.toNative(), node.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void Record() throws StatusException {
        int status = NativeMethods.xnRecord(this.toNative());
        WrapperUtils.throwOnError(status);
    }
}

