/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import projectkyoto.mmd.file.util2.BufferUtil;

public class GeometryOptimizer {
    Set<Mesh> meshSet = new HashSet<Mesh>();
    int interleavedSize;
    ByteBuffer interleavedBuffer;

    public static GeometryOptimizer createNewInstance() {
        return new GeometryOptimizer();
    }

    protected GeometryOptimizer() {
    }

    public void add(Spatial sp) {
        sp.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                GeometryOptimizer.this.add(geom);
            }
        });
    }

    public void add(Geometry geom) {
        Mesh mesh = geom.getMesh();
        if (mesh != null) {
            this.meshSet.add(mesh);
        }
    }

    public void add(Mesh mesh) {
        this.meshSet.add(mesh);
    }

    public void optimize2() {
        for (Mesh mesh : this.meshSet) {
            mesh.setInterleaved();
            for (VertexBuffer vb : mesh.getBufferList()) {
                System.out.println("type = " + vb.getBufferType() + "stride = " + vb.getStride() + "offset " + vb.getOffset());
            }
            System.out.println("done");
        }
    }

    String createVBKey(VertexBuffer vb) {
        StringBuilder sb = new StringBuilder();
        sb.append(vb.getNumComponents()).append(",").append(vb.getFormat()).append(",").append(vb.isNormalized()).append(",").append(vb.getStride()).append(",").append(vb.getOffset()).append(",").append(vb.getBufferType());
        return sb.toString();
    }

    public void optimize3() {
        HashMap<String, VertexBuffer> vbMap = new HashMap<String, VertexBuffer>();
        ArrayList<VertexBuffer> vbList = new ArrayList<VertexBuffer>();
        for (Mesh mesh : this.meshSet) {
            vbList.clear();
            for (VertexBuffer vb : mesh.getBufferList()) {
                if (vb.getBufferType().equals((Object)VertexBuffer.Type.Index) || vb.getBufferType().equals((Object)VertexBuffer.Type.InterleavedData) || vb.getStride() <= 0) continue;
                String key = this.createVBKey(vb);
                System.out.append("key = " + key);
                VertexBuffer vb2 = (VertexBuffer)vbMap.get(key);
                if (vb2 != null) {
                    vbList.add(vb2);
                    continue;
                }
                vbMap.put(key, vb);
            }
            for (VertexBuffer vb : vbList) {
            }
        }
    }

    public void optimize() {
        this.calcInterleavedSize();
        this.interleavedBuffer = BufferUtil.createByteBuffer(this.interleavedSize);
        VertexBuffer allData = new VertexBuffer(VertexBuffer.Type.InterleavedData);
        allData.setupData(VertexBuffer.Usage.Static, 1, VertexBuffer.Format.UnsignedByte, (Buffer)this.interleavedBuffer);
        int offset = 0;
        for (Mesh mesh : this.meshSet) {
            int stride = 0;
            for (VertexBuffer vb : mesh.getBufferList()) {
                if (vb.getBufferType().equals((Object)VertexBuffer.Type.Index) || vb.getBufferType().equals((Object)VertexBuffer.Type.InterleavedData)) continue;
                vb.getData().clear();
                vb.setOffset(offset + stride);
                stride += vb.getComponentsLength();
            }
            for (VertexBuffer vb : mesh.getBufferList()) {
                if (vb.getBufferType().equals((Object)VertexBuffer.Type.Index) || vb.getBufferType().equals((Object)VertexBuffer.Type.InterleavedData)) continue;
                vb.setStride(stride);
            }
            for (int i = 0; i < mesh.getVertexCount(); ++i) {
                block11: for (VertexBuffer vb : mesh.getBufferList()) {
                    if (vb.getBufferType().equals((Object)VertexBuffer.Type.Index) || vb.getBufferType().equals((Object)VertexBuffer.Type.InterleavedData)) continue;
                    switch (vb.getFormat()) {
                        case Float: {
                            FloatBuffer fb = (FloatBuffer)vb.getData();
                            for (int comp = 0; comp < vb.getNumComponents(); ++comp) {
                                this.interleavedBuffer.putFloat(fb.get());
                            }
                            continue block11;
                        }
                        case Byte: 
                        case UnsignedByte: {
                            ByteBuffer bb = (ByteBuffer)vb.getData();
                            for (int comp = 0; comp < vb.getNumComponents(); ++comp) {
                                this.interleavedBuffer.put(bb.get());
                            }
                            continue block11;
                        }
                        case Half: 
                        case Short: 
                        case UnsignedShort: {
                            ShortBuffer sb = (ShortBuffer)vb.getData();
                            for (int comp = 0; comp < vb.getNumComponents(); ++comp) {
                                this.interleavedBuffer.putShort(sb.get());
                            }
                            continue block11;
                        }
                        case Int: 
                        case UnsignedInt: {
                            IntBuffer ib = (IntBuffer)vb.getData();
                            for (int comp = 0; comp < vb.getNumComponents(); ++comp) {
                                this.interleavedBuffer.putInt(ib.get());
                            }
                            continue block11;
                        }
                        case Double: {
                            DoubleBuffer db = (DoubleBuffer)vb.getData();
                            for (int comp = 0; comp < vb.getNumComponents(); ++comp) {
                                this.interleavedBuffer.putDouble(db.get());
                            }
                            break;
                        }
                    }
                }
            }
            offset = this.interleavedBuffer.position();
            for (VertexBuffer vb : mesh.getBufferList()) {
                if (vb.getBufferType().equals((Object)VertexBuffer.Type.Index) || vb.getBufferType().equals((Object)VertexBuffer.Type.InterleavedData)) continue;
                vb.updateData(null);
            }
            mesh.setBuffer(allData);
        }
    }

    int calcInterleavedSize() {
        this.interleavedSize = 0;
        for (Mesh mesh : this.meshSet) {
            for (VertexBuffer vb : mesh.getBufferList()) {
                if (vb.getBufferType().equals((Object)VertexBuffer.Type.Index) || vb.getBufferType().equals((Object)VertexBuffer.Type.InterleavedData)) continue;
                int limit = vb.getData().capacity();
                this.interleavedSize += limit * vb.getFormat().getComponentSize();
            }
        }
        return this.interleavedSize;
    }
}

