/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.util2.BufferUtil;

public class PMDBoneDispNameList
implements Serializable {
    private int boneDispNameCount;
    private String[] dispNameArray;

    public PMDBoneDispNameList() {
    }

    public PMDBoneDispNameList(DataInputStreamLittleEndian is) throws IOException {
        this.boneDispNameCount = is.readUnsignedByte();
        this.dispNameArray = new String[this.boneDispNameCount];
        for (int i = 0; i < this.boneDispNameCount; ++i) {
            this.dispNameArray[i] = is.readString(50);
        }
    }

    public void readFromBuffer(ByteBuffer bb) {
        this.boneDispNameCount = bb.get();
        this.dispNameArray = new String[this.boneDispNameCount];
        for (int i = 0; i < this.boneDispNameCount; ++i) {
            this.dispNameArray[i] = BufferUtil.readString(bb, 50);
        }
    }

    public void writeToBuffer(ByteBuffer bb) {
    }

    public String toString() {
        return "PMDBoneDispNameList{boneDispNameCount=" + this.boneDispNameCount + ", dispNameArray=" + this.dispNameArray + '}';
    }

    public int getBoneDispNameCount() {
        return this.boneDispNameCount;
    }

    public void setBoneDispNameCount(int boneDispNameCount) {
        this.boneDispNameCount = boneDispNameCount;
    }

    public String[] getDispNameArray() {
        return this.dispNameArray;
    }

    public void setDispNameArray(String[] dispNameArray) {
        this.dispNameArray = dispNameArray;
    }
}

