/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.InvalidVMDFileException;
import projectkyoto.mmd.file.VMDMotion;
import projectkyoto.mmd.file.VMDSkin;

public class VMDFile
implements Serializable {
    private String vmdHeader;
    private String vmdModelName;
    private int motionCount;
    private VMDMotion[] motionArray;
    private int skinCount;
    private VMDSkin[] skinArray;

    public VMDFile() {
    }

    public VMDFile(URL url) throws IOException {
        this.read(url.openStream());
    }

    public VMDFile(InputStream is2) throws IOException {
        this.read(is2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream is2) throws IOException {
        FilterInputStream is = null;
        try {
            int i;
            is = new DataInputStreamLittleEndian(new BufferedInputStream(is2));
            this.vmdHeader = ((DataInputStreamLittleEndian)is).readString(30);
            if (!"Vocaloid Motion Data 0002".equals(this.vmdHeader)) {
                throw new InvalidVMDFileException();
            }
            this.vmdModelName = ((DataInputStreamLittleEndian)is).readString(20);
            this.motionCount = ((DataInputStreamLittleEndian)is).readInt();
            this.motionArray = new VMDMotion[this.motionCount];
            for (i = 0; i < this.motionCount; ++i) {
                this.motionArray[i] = new VMDMotion((DataInputStreamLittleEndian)is);
            }
            this.skinCount = ((DataInputStreamLittleEndian)is).readInt();
            this.skinArray = new VMDSkin[this.skinCount];
            for (i = 0; i < this.skinCount; ++i) {
                this.skinArray[i] = new VMDSkin((DataInputStreamLittleEndian)is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{vmdHeader = ").append(this.vmdHeader).append("\n");
        sb.append("vmdModelName = ").append(this.vmdModelName).append("\n");
        sb.append("motionCount = ").append(this.motionCount).append("\n");
        sb.append("motionArray = {\n");
        for (VMDMotion vMDMotion : this.motionArray) {
            sb.append(vMDMotion).append("\n");
        }
        sb.append("}\n");
        sb.append("skinCount = ").append(this.skinCount).append("\n");
        sb.append("skinArray = {\n");
        for (Serializable serializable : this.skinArray) {
            sb.append(serializable).append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public VMDMotion[] getMotionArray() {
        return this.motionArray;
    }

    public void setMotionArray(VMDMotion[] motionArray) {
        this.motionArray = motionArray;
    }

    public int getMotionCount() {
        return this.motionCount;
    }

    public void setMotionCount(int motionCount) {
        this.motionCount = motionCount;
    }

    public VMDSkin[] getSkinArray() {
        return this.skinArray;
    }

    public void setSkinArray(VMDSkin[] skinArray) {
        this.skinArray = skinArray;
    }

    public int getSkinCount() {
        return this.skinCount;
    }

    public void setSkinCount(int skinCount) {
        this.skinCount = skinCount;
    }

    public String getVmdHeader() {
        return this.vmdHeader;
    }

    public void setVmdHeader(String vmdHeader) {
        this.vmdHeader = vmdHeader;
    }

    public String getVmdModelName() {
        return this.vmdModelName;
    }

    public void setVmdModelName(String vmdModelName) {
        this.vmdModelName = vmdModelName;
    }
}

