/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.XColorRGB;

public class XColorRGBA
extends XColorRGB
implements Serializable {
    private float alpha;

    public XColorRGBA() {
    }

    public XColorRGBA(float red, float green, float blue, float alpha) {
        super(red, green, blue);
        this.alpha = alpha;
    }

    public XColorRGBA(DataInputStreamLittleEndian is) throws IOException {
        super(is);
        this.alpha = is.readFloat();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public String toString() {
        return "{red = " + this.getRed() + " green = " + this.getGreen() + " blue = " + this.getBlue() + " alpha = " + this.alpha + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        XColorRGBA other = (XColorRGBA)obj;
        return Float.floatToIntBits(this.alpha) == Float.floatToIntBits(other.alpha);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

