/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDSkinData;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.MeshConverter;

public class SkinMeshData
implements Serializable {
    PMDModel model;
    List<Integer> boneList = new ArrayList<Integer>();
    List<PMDVertex> vertexList = new ArrayList<PMDVertex>();
    Map<PMDMaterial, List<Integer>> indexMap = new HashMap<PMDMaterial, List<Integer>>();

    public SkinMeshData(MeshConverter mc, PMDModel model) {
        this.model = model;
        for (PMDSkinData sd : model.getSkinData()) {
            if (sd.getSkinType() != 0) continue;
            for (int i = 0; i < sd.getSkinVertCount(); ++i) {
                int skinVertIndex = sd.getIndexBuf().get(i) & 0xFFFF;
                try {
                    PMDVertex v = model.getVertex(skinVertIndex);
                    this.vertexList.add(v);
                    mc.skinTmpVertMap.put(skinVertIndex, i);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            break;
        }
    }

    public void addTriangle(MeshConverter mc, PMDMaterial material, int i1, int i2, int i3) {
        this.addBoneList(i1);
        this.addBoneList(i2);
        this.addBoneList(i3);
        List<Integer> indexList = this.indexMap.get(material);
        if (indexList == null) {
            indexList = new ArrayList<Integer>();
            this.indexMap.put(material, indexList);
        }
        this.addVertex(mc, indexList, i1);
        this.addVertex(mc, indexList, i2);
        this.addVertex(mc, indexList, i3);
    }

    private void addBoneList(int vertIndex) {
        PMDVertex v = this.model.getVertex(vertIndex);
        if (!this.boneList.contains(v.getBoneNum1())) {
            this.boneList.add(v.getBoneNum1());
        }
        if (!this.boneList.contains(v.getBoneNum2())) {
            this.boneList.add(v.getBoneNum2());
        }
    }

    private void addVertex(MeshConverter mc, List<Integer> indexList, int vertIndex) {
        PMDVertex v = this.model.getVertex(vertIndex);
        Integer index = mc.skinTmpVertMap.get(vertIndex);
        if (index != null) {
            int newVertIndex = index;
        } else {
            int newVertIndex = this.vertexList.size();
            this.vertexList.add(v);
            mc.skinTmpVertMap.put(vertIndex, newVertIndex);
            index = newVertIndex;
        }
        indexList.add(index);
    }

    public List<Integer> getBoneList() {
        return this.boneList;
    }

    public void setBoneList(List<Integer> boneList) {
        this.boneList = boneList;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    public List<PMDVertex> getVertexList() {
        return this.vertexList;
    }

    public void setVertexList(List<PMDVertex> vertexList) {
        this.vertexList = vertexList;
    }

    public Map<PMDMaterial, List<Integer>> getIndexMap() {
        return this.indexMap;
    }

    public void setIndexMap(Map<PMDMaterial, List<Integer>> indexMap) {
        this.indexMap = indexMap;
    }
}

