/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.pack;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public class ReadableBufferChannel
implements ReadableByteChannel {
    private ByteBuffer bb;

    public ReadableBufferChannel(ByteBuffer bb) {
        if (bb == null) {
            throw new NullPointerException();
        }
        this.bb = bb;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.bb == null) {
            throw new ClosedChannelException();
        }
        int toRead = Math.min(dst.remaining(), this.bb.remaining());
        if (toRead == 0) {
            return -1;
        }
        int prevLim = this.bb.limit();
        int newLim = this.bb.position() + toRead;
        assert (newLim <= prevLim);
        this.bb.limit(newLim);
        assert (this.bb.remaining() == toRead);
        dst.put(this.bb);
        this.bb.limit(prevLim);
        return toRead;
    }

    public boolean isOpen() {
        return this.bb != null;
    }

    public void close() throws IOException {
        this.bb = null;
    }
}

