/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.math.ColorRGBA;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorTags {
    private static final Pattern colorPattern = Pattern.compile("\\\\#([0-9a-fA-F]{8})#|\\\\#([0-9a-fA-F]{6})#|\\\\#([0-9a-fA-F]{4})#|\\\\#([0-9a-fA-F]{3})#");
    private LinkedList<Range> colors = new LinkedList();
    private String text;

    ColorTags() {
    }

    ColorTags(String seq) {
        this.setText(seq);
    }

    String getPlainText() {
        return this.text;
    }

    LinkedList<Range> getTags() {
        return this.colors;
    }

    void setText(String charSeq) {
        this.colors.clear();
        if (charSeq == null) {
            return;
        }
        Matcher m = colorPattern.matcher(charSeq);
        if (m.find()) {
            StringBuilder builder = new StringBuilder(charSeq.length() - 7);
            int startIndex = 0;
            do {
                String colorStr = null;
                for (int i = 1; i <= 4 && colorStr == null; ++i) {
                    colorStr = m.group(i);
                }
                builder.append(charSeq.subSequence(startIndex, m.start()));
                Range range = new Range(builder.length(), colorStr);
                startIndex = m.end();
                this.colors.add(range);
            } while (m.find());
            builder.append(charSeq.subSequence(startIndex, charSeq.length()));
            this.text = builder.toString();
        } else {
            this.text = charSeq;
        }
    }

    class Range {
        int start;
        ColorRGBA color;

        Range(int start, String colorStr) {
            this.start = start;
            this.color = new ColorRGBA();
            if (colorStr.length() >= 6) {
                this.color.set((float)Integer.parseInt(((Object)colorStr.subSequence(0, 2)).toString(), 16) / 255.0f, (float)Integer.parseInt(((Object)colorStr.subSequence(2, 4)).toString(), 16) / 255.0f, (float)Integer.parseInt(((Object)colorStr.subSequence(4, 6)).toString(), 16) / 255.0f, 1.0f);
                if (colorStr.length() == 8) {
                    this.color.a = (float)Integer.parseInt(((Object)colorStr.subSequence(6, 8)).toString(), 16) / 255.0f;
                }
            } else {
                this.color.set((float)Integer.parseInt(Character.toString(colorStr.charAt(0)), 16) / 15.0f, (float)Integer.parseInt(Character.toString(colorStr.charAt(1)), 16) / 15.0f, (float)Integer.parseInt(Character.toString(colorStr.charAt(2)), 16) / 15.0f, 1.0f);
                if (colorStr.length() == 4) {
                    this.color.a = (float)Integer.parseInt(Character.toString(colorStr.charAt(3)), 16) / 15.0f;
                }
            }
        }
    }
}

