/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.Asset;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.material.Technique;
import com.jme3.material.TechniqueDef;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.util.ListMap;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Material
implements Asset,
Cloneable,
Savable,
Comparable<Material> {
    public static final int SAVABLE_VERSION = 2;
    private static final Logger logger = Logger.getLogger(Material.class.getName());
    private static final RenderState additiveLight = new RenderState();
    private static final RenderState depthOnly = new RenderState();
    private static final Quaternion nullDirLight = new Quaternion(0.0f, -1.0f, 0.0f, -1.0f);
    private AssetKey key;
    private MaterialDef def;
    private ListMap<String, MatParam> paramValues = new ListMap();
    private Technique technique;
    private HashMap<String, Technique> techniques = new HashMap();
    private Technique[] techniqueArray = null;
    private int nextTexUnit = 0;
    private RenderState additionalState = null;
    private RenderState mergedRenderState = new RenderState();
    private boolean transparent = false;
    private boolean receivesShadows = false;
    private int sortingId = -1;
    private transient ColorRGBA ambientLightColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);

    public Material(MaterialDef def) {
        if (def == null) {
            throw new NullPointerException("Material definition cannot be null");
        }
        this.def = def;
        for (MatParam param : def.getMaterialParams()) {
            if (param.getValue() == null) continue;
            this.setParam(param.getName(), param.getVarType(), param.getValue());
        }
    }

    public Material(AssetManager contentMan, String defName) {
        this((MaterialDef)contentMan.loadAsset(new AssetKey(defName)));
    }

    public Material() {
    }

    public String getAssetName() {
        return this.key != null ? this.key.getName() : null;
    }

    @Override
    public void setKey(AssetKey key) {
        this.key = key;
    }

    @Override
    public AssetKey getKey() {
        return this.key;
    }

    public int getSortId() {
        Technique t = this.getActiveTechnique();
        if (this.sortingId == -1 && t != null && t.getShader() != null) {
            int texId = -1;
            for (int i = 0; i < this.paramValues.size(); ++i) {
                MatParamTexture tex;
                MatParam param = this.paramValues.getValue(i);
                if (!(param instanceof MatParamTexture) || (tex = (MatParamTexture)param).getTextureValue() == null || tex.getTextureValue().getImage() == null) continue;
                if (texId == -1) {
                    texId = 0;
                }
                texId += tex.getTextureValue().getImage().getId() % 255;
            }
            this.sortingId = texId + t.getShader().getId() * 1000;
        }
        return this.sortingId;
    }

    @Override
    public int compareTo(Material m) {
        return m.getSortId() - this.getSortId();
    }

    public Material clone() {
        try {
            Material mat = (Material)super.clone();
            if (this.additionalState != null) {
                mat.additionalState = this.additionalState.clone();
            }
            mat.technique = null;
            mat.techniques = new HashMap();
            mat.techniqueArray = null;
            mat.paramValues = new ListMap();
            for (int i = 0; i < this.paramValues.size(); ++i) {
                Map.Entry<String, MatParam> entry = this.paramValues.getEntry(i);
                mat.paramValues.put(entry.getKey(), entry.getValue().clone());
            }
            return mat;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Technique getActiveTechnique() {
        return this.technique;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean isReceivesShadows() {
        return this.receivesShadows;
    }

    public void setReceivesShadows(boolean receivesShadows) {
        this.receivesShadows = receivesShadows;
    }

    public RenderState getAdditionalRenderState() {
        if (this.additionalState == null) {
            this.additionalState = RenderState.ADDITIONAL.clone();
        }
        return this.additionalState;
    }

    public MaterialDef getMaterialDef() {
        return this.def;
    }

    public MatParam getParam(String name) {
        MatParam param = this.paramValues.get(name);
        if (param instanceof MatParam) {
            return param;
        }
        return null;
    }

    public MatParamTexture getTextureParam(String name) {
        MatParam param = this.paramValues.get(name);
        if (param instanceof MatParamTexture) {
            return (MatParamTexture)param;
        }
        return null;
    }

    public Collection<MatParam> getParams() {
        return this.paramValues.values();
    }

    private String checkSetParam(VarType type, String name) {
        MatParam paramDef = this.def.getMaterialParam(name);
        String newName = name;
        if (paramDef == null && name.startsWith("m_")) {
            newName = name.substring(2);
            paramDef = this.def.getMaterialParam(newName);
            if (paramDef == null) {
                throw new IllegalArgumentException("Material parameter is not defined: " + name);
            }
            logger.log(Level.WARNING, "Material parameter {0} uses a deprecated naming convention use {1} instead ", new Object[]{name, newName});
        } else if (paramDef == null) {
            throw new IllegalArgumentException("Material parameter is not defined: " + name);
        }
        if (type != null && paramDef.getVarType() != type) {
            logger.log(Level.WARNING, "Material parameter being set: {0} with type {1} doesn''t match definition types {2}", new Object[]{name, type.name(), paramDef.getVarType()});
        }
        return newName;
    }

    public int getParamIndex(String name) {
        for (int i = this.paramValues.size() - 1; i >= 0; --i) {
            if (!name.equals(this.paramValues.getKey(i))) continue;
            return i;
        }
        return -1;
    }

    public void setParam(String name, VarType type, Object value) {
        Object value2;
        name = this.checkSetParam(type, name);
        boolean techniqueUpdateNeeded = false;
        MatParam val = this.getParam(name);
        if (val == null) {
            MatParam paramDef = this.def.getMaterialParam(name);
            val = new MatParam(type, name, value, paramDef.getFixedFuncBinding());
            val.setValue(value);
            this.paramValues.put(name, val);
            techniqueUpdateNeeded = true;
        } else {
            val.setValue(value);
        }
        Object object = value2 = val.multiData != null ? val.multiData : value;
        if (this.techniqueArray == null) {
            this.setTechniqueArray();
        }
        for (Technique tech : this.techniqueArray) {
            tech.notifySetParam(name, type, value2);
        }
        if (techniqueUpdateNeeded) {
            for (Technique tech : this.techniqueArray) {
                tech.setNeedReload(true);
            }
        }
    }

    public void setParam(int paramIndex, VarType type, Object value) {
        Object value2;
        MatParam val = this.paramValues.getValue(paramIndex);
        val.setValue(value);
        Object object = value2 = val.multiData != null ? val.multiData : value;
        if (this.techniqueArray == null) {
            this.setTechniqueArray();
        }
        this.paramValues.getValue(0);
        for (Technique tech : this.techniqueArray) {
            tech.notifySetParam(paramIndex, type, value2);
        }
    }

    public void clearParam(String name) {
        MatParam matParam = this.getParam(name);
        if (matParam != null) {
            this.paramValues.put(name, null);
            if (this.techniqueArray == null) {
                this.setTechniqueArray();
            }
            for (Technique tech : this.techniqueArray) {
                tech.notifyClearParam(name);
            }
            if (matParam instanceof MatParamTexture) {
                int texUnit = ((MatParamTexture)matParam).getUnit();
                --this.nextTexUnit;
                for (MatParam param : this.paramValues.values()) {
                    MatParamTexture texParam;
                    if (!(param instanceof MatParamTexture) || (texParam = (MatParamTexture)param).getUnit() <= texUnit) continue;
                    texParam.setUnit(texParam.getUnit() - 1);
                }
            }
        }
    }

    private void clearTextureParam(String name) {
        MatParamTexture val = this.getTextureParam(name = this.checkSetParam(null, name));
        if (val == null) {
            throw new IllegalArgumentException("The given texture for parameter \"" + name + "\" is null.");
        }
        int texUnit = val.getUnit();
        this.paramValues.put(name, null);
        --this.nextTexUnit;
        for (MatParam param : this.paramValues.values()) {
            MatParamTexture texParam;
            if (!(param instanceof MatParamTexture) || (texParam = (MatParamTexture)param).getUnit() <= texUnit) continue;
            texParam.setUnit(texParam.getUnit() - 1);
        }
        this.sortingId = -1;
    }

    public void setTextureParam(String name, VarType type, Texture value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        boolean techniqueUpdateNeeded = false;
        MatParamTexture val = this.getTextureParam(name = this.checkSetParam(type, name));
        if (val == null) {
            this.paramValues.put(name, new MatParamTexture(type, name, value, this.nextTexUnit++));
            techniqueUpdateNeeded = true;
        } else {
            val.setTextureValue(value);
        }
        if (this.techniqueArray == null) {
            this.setTechniqueArray();
        }
        for (Technique tech : this.techniqueArray) {
            tech.notifySetParam(name, type, (Object)(this.nextTexUnit - 1));
        }
        if (techniqueUpdateNeeded) {
            for (Technique tech : this.techniqueArray) {
                tech.setNeedReload(true);
            }
        }
        this.sortingId = -1;
    }

    public void setTexture(String name, Texture value) {
        if (value == null) {
            this.clearTextureParam(name);
            return;
        }
        VarType paramType = null;
        switch (value.getType()) {
            case TwoDimensional: {
                paramType = VarType.Texture2D;
                break;
            }
            case TwoDimensionalArray: {
                paramType = VarType.TextureArray;
                break;
            }
            case ThreeDimensional: {
                paramType = VarType.Texture3D;
                break;
            }
            case CubeMap: {
                paramType = VarType.TextureCubeMap;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)value.getType()));
            }
        }
        this.setTextureParam(name, paramType, value);
    }

    public void setMatrix4(String name, Matrix4f value) {
        this.setParam(name, VarType.Matrix4, (Object)value);
    }

    public void setBoolean(String name, boolean value) {
        this.setParam(name, VarType.Boolean, (Object)value);
    }

    public void setFloat(String name, float value) {
        this.setParam(name, VarType.Float, (Object)Float.valueOf(value));
    }

    public void setInt(String name, int value) {
        this.setParam(name, VarType.Int, (Object)value);
    }

    public void setColor(String name, ColorRGBA value) {
        this.setParam(name, VarType.Vector4, (Object)value);
    }

    public void setVector2(String name, Vector2f value) {
        this.setParam(name, VarType.Vector2, (Object)value);
    }

    public void setVector3(String name, Vector3f value) {
        this.setParam(name, VarType.Vector3, (Object)value);
    }

    public void setVector4(String name, Vector4f value) {
        this.setParam(name, VarType.Vector4, (Object)value);
    }

    private ColorRGBA getAmbientColor(LightList lightList) {
        this.ambientLightColor.set(0.0f, 0.0f, 0.0f, 1.0f);
        for (int j = 0; j < lightList.size(); ++j) {
            Light l = lightList.get(j);
            if (!(l instanceof AmbientLight)) continue;
            this.ambientLightColor.addLocal(l.getColor());
        }
        this.ambientLightColor.a = 1.0f;
        return this.ambientLightColor;
    }

    protected void updateLightListUniforms(Shader shader, Geometry g, int numLights) {
        if (numLights == 0) {
            return;
        }
        LightList lightList = g.getWorldLightList();
        Uniform lightColor = shader.getUniform("g_LightColor");
        Uniform lightPos = shader.getUniform("g_LightPosition");
        Uniform lightDir = shader.getUniform("g_LightDirection");
        lightColor.setVector4Length(numLights);
        lightPos.setVector4Length(numLights);
        lightDir.setVector4Length(numLights);
        Uniform ambientColor = shader.getUniform("g_AmbientLightColor");
        ambientColor.setValue(VarType.Vector4, this.getAmbientColor(lightList));
        int lightIndex = 0;
        block6: for (int i = 0; i < numLights; ++i) {
            if (lightList.size() <= i) {
                lightColor.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, lightIndex);
                lightPos.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, lightIndex);
            } else {
                Light l = lightList.get(i);
                ColorRGBA color = l.getColor();
                lightColor.setVector4InArray(color.getRed(), color.getGreen(), color.getBlue(), l.getType().getId(), i);
                switch (l.getType()) {
                    case Directional: {
                        DirectionalLight dl = (DirectionalLight)l;
                        Vector3f dir = dl.getDirection();
                        lightPos.setVector4InArray(dir.getX(), dir.getY(), dir.getZ(), -1.0f, lightIndex);
                        break;
                    }
                    case Point: {
                        PointLight pl = (PointLight)l;
                        Vector3f pos = pl.getPosition();
                        float invRadius = pl.getInvRadius();
                        lightPos.setVector4InArray(pos.getX(), pos.getY(), pos.getZ(), invRadius, lightIndex);
                        break;
                    }
                    case Spot: {
                        SpotLight sl = (SpotLight)l;
                        Vector3f pos2 = sl.getPosition();
                        Vector3f dir2 = sl.getDirection();
                        float invRange = sl.getInvSpotRange();
                        float spotAngleCos = sl.getPackedAngleCos();
                        lightPos.setVector4InArray(pos2.getX(), pos2.getY(), pos2.getZ(), invRange, lightIndex);
                        lightDir.setVector4InArray(dir2.getX(), dir2.getY(), dir2.getZ(), spotAngleCos, lightIndex);
                        break;
                    }
                    case Ambient: {
                        continue block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown type of light: " + (Object)((Object)l.getType()));
                    }
                }
            }
            ++lightIndex;
        }
        while (lightIndex < numLights) {
            lightColor.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, lightIndex);
            lightPos.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, lightIndex);
            ++lightIndex;
        }
    }

    protected void renderMultipassLighting(Shader shader, Geometry g, RenderManager rm) {
        Renderer r = rm.getRenderer();
        LightList lightList = g.getWorldLightList();
        Uniform lightDir = shader.getUniform("g_LightDirection");
        Uniform lightColor = shader.getUniform("g_LightColor");
        Uniform lightPos = shader.getUniform("g_LightPosition");
        Uniform ambientColor = shader.getUniform("g_AmbientLightColor");
        boolean isFirstLight = true;
        boolean isSecondLight = false;
        for (int i = 0; i < lightList.size(); ++i) {
            Light l = lightList.get(i);
            if (l instanceof AmbientLight) continue;
            if (isFirstLight) {
                ambientColor.setValue(VarType.Vector4, this.getAmbientColor(lightList));
                isFirstLight = false;
                isSecondLight = true;
            } else if (isSecondLight) {
                ambientColor.setValue(VarType.Vector4, ColorRGBA.Black);
                r.applyRenderState(additiveLight);
                isSecondLight = false;
            }
            TempVars vars = TempVars.get();
            Quaternion tmpLightDirection = vars.quat1;
            Quaternion tmpLightPosition = vars.quat2;
            ColorRGBA tmpLightColor = vars.color;
            Vector4f tmpVec = vars.vect4f;
            ColorRGBA color = l.getColor();
            tmpLightColor.set(color);
            tmpLightColor.a = l.getType().getId();
            lightColor.setValue(VarType.Vector4, tmpLightColor);
            switch (l.getType()) {
                case Directional: {
                    DirectionalLight dl = (DirectionalLight)l;
                    Vector3f dir = dl.getDirection();
                    tmpLightPosition.set(dir.getX(), dir.getY(), dir.getZ(), -1.0f);
                    lightPos.setValue(VarType.Vector4, tmpLightPosition);
                    tmpLightDirection.set(0.0f, 0.0f, 0.0f, 0.0f);
                    lightDir.setValue(VarType.Vector4, tmpLightDirection);
                    break;
                }
                case Point: {
                    PointLight pl = (PointLight)l;
                    Vector3f pos = pl.getPosition();
                    float invRadius = pl.getInvRadius();
                    tmpLightPosition.set(pos.getX(), pos.getY(), pos.getZ(), invRadius);
                    lightPos.setValue(VarType.Vector4, tmpLightPosition);
                    tmpLightDirection.set(0.0f, 0.0f, 0.0f, 0.0f);
                    lightDir.setValue(VarType.Vector4, tmpLightDirection);
                    break;
                }
                case Spot: {
                    SpotLight sl = (SpotLight)l;
                    Vector3f pos2 = sl.getPosition();
                    Vector3f dir2 = sl.getDirection();
                    float invRange = sl.getInvSpotRange();
                    float spotAngleCos = sl.getPackedAngleCos();
                    tmpLightPosition.set(pos2.getX(), pos2.getY(), pos2.getZ(), invRange);
                    lightPos.setValue(VarType.Vector4, tmpLightPosition);
                    tmpVec.set(dir2.getX(), dir2.getY(), dir2.getZ(), 0.0f);
                    rm.getCurrentCamera().getViewMatrix().mult(tmpVec, tmpVec);
                    tmpLightDirection.set(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), spotAngleCos);
                    lightDir.setValue(VarType.Vector4, tmpLightDirection);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type of light: " + (Object)((Object)l.getType()));
                }
            }
            vars.release();
            r.setShader(shader);
            r.renderMesh(g.getMesh(), g.getLodLevel(), 1);
        }
        if (isFirstLight && lightList.size() > 0) {
            ambientColor.setValue(VarType.Vector4, this.getAmbientColor(lightList));
            lightColor.setValue(VarType.Vector4, ColorRGBA.BlackNoAlpha);
            lightPos.setValue(VarType.Vector4, nullDirLight);
            r.setShader(shader);
            r.renderMesh(g.getMesh(), g.getLodLevel(), 1);
        }
    }

    public void selectTechnique(String name, RenderManager renderManager) {
        Technique tech = this.techniques.get(name);
        if (tech == null) {
            EnumSet<Caps> rendererCaps = renderManager.getRenderer().getCaps();
            if (name.equals("Default")) {
                List<TechniqueDef> techDefs = this.def.getDefaultTechniques();
                if (techDefs == null || techDefs.isEmpty()) {
                    throw new IllegalArgumentException("No default techniques are available on material '" + this.def.getName() + "'");
                }
                TechniqueDef lastTech = null;
                for (TechniqueDef techDef : techDefs) {
                    if (rendererCaps.containsAll(techDef.getRequiredCaps())) {
                        tech = new Technique(this, techDef);
                        this.putTechnique(name, tech);
                        break;
                    }
                    lastTech = techDef;
                }
                if (tech == null) {
                    throw new UnsupportedOperationException("No default technique on material '" + this.def.getName() + "'\n" + " is supported by the video hardware. The caps " + lastTech.getRequiredCaps() + " are required.");
                }
            } else {
                TechniqueDef techDef = this.def.getTechniqueDef(name);
                if (techDef == null) {
                    throw new IllegalArgumentException("For material " + this.def.getName() + ", technique not found: " + name);
                }
                if (!rendererCaps.containsAll(techDef.getRequiredCaps())) {
                    throw new UnsupportedOperationException("The explicitly chosen technique '" + name + "' on material '" + this.def.getName() + "'\n" + "requires caps " + techDef.getRequiredCaps() + " which are not " + "supported by the video renderer");
                }
                tech = new Technique(this, techDef);
                this.putTechnique(name, tech);
            }
        } else if (this.technique == tech) {
            return;
        }
        this.technique = tech;
        if (this.technique.isNeedReload()) {
            tech.makeCurrent(this.def.getAssetManager(), this.paramValues);
        }
        this.sortingId = -1;
    }

    private void autoSelectTechnique(RenderManager rm) {
        if (this.technique == null) {
            if (!rm.getRenderer().getCaps().contains((Object)Caps.GLSL100)) {
                this.selectTechnique("FixedFunc", rm);
            } else {
                this.selectTechnique("Default", rm);
            }
        } else if (this.technique.isNeedReload()) {
            this.technique.makeCurrent(this.def.getAssetManager(), this.paramValues);
        }
    }

    public void preload(RenderManager rm) {
        this.autoSelectTechnique(rm);
        Renderer r = rm.getRenderer();
        TechniqueDef techDef = this.technique.getDef();
        Collection<MatParam> params = this.paramValues.values();
        for (MatParam param : params) {
            if (param instanceof MatParamTexture) {
                MatParamTexture texParam = (MatParamTexture)param;
                r.setTexture(0, texParam.getTextureValue());
                continue;
            }
            if (!techDef.isUsingShaders()) continue;
            this.technique.updateUniformParam(param.getName(), param.getVarType(), param.getValue(), true);
        }
        Shader shader = this.technique.getShader();
        if (techDef.isUsingShaders()) {
            r.setShader(shader);
        }
    }

    private void clearUniformsSetByCurrent(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform u = uniforms.getValue(i);
            u.clearSetByCurrentMaterial();
        }
    }

    private void resetUniformsNotSetByCurrent(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform u = uniforms.getValue(i);
            if (u.isSetByCurrentMaterial()) continue;
            u.clearValue();
        }
    }

    public void render(Geometry geom, RenderManager rm) {
        this.autoSelectTechnique(rm);
        Renderer r = rm.getRenderer();
        TechniqueDef techDef = this.technique.getDef();
        if (techDef.getLightMode() == TechniqueDef.LightMode.MultiPass && geom.getWorldLightList().size() == 0) {
            return;
        }
        if (rm.getForcedRenderState() != null) {
            r.applyRenderState(rm.getForcedRenderState());
        } else if (techDef.getRenderState() != null) {
            r.applyRenderState(techDef.getRenderState().copyMergedTo(this.additionalState, this.mergedRenderState));
        } else {
            r.applyRenderState(RenderState.DEFAULT.copyMergedTo(this.additionalState, this.mergedRenderState));
        }
        boolean needReloadParams = false;
        if (this.technique.isNeedReload()) {
            this.technique.makeCurrent(this.def.getAssetManager(), this.paramValues);
            needReloadParams = true;
        }
        if (techDef.isUsingShaders()) {
            this.clearUniformsSetByCurrent(this.technique.getShader());
            rm.updateUniformBindings(this.technique.getWorldBindUniforms());
        }
        for (int i = this.paramValues.size() - 1; i >= 0; --i) {
            MatParam param = this.paramValues.getValue(i);
            if (param == null) continue;
            param.apply(r, this.technique, i);
        }
        Shader shader = this.technique.getShader();
        switch (techDef.getLightMode()) {
            case Disable: {
                r.setLighting(null);
                break;
            }
            case SinglePass: {
                this.updateLightListUniforms(shader, geom, 4);
                break;
            }
            case FixedPipeline: {
                r.setLighting(geom.getWorldLightList());
                break;
            }
            case MultiPass: {
                this.resetUniformsNotSetByCurrent(shader);
                this.renderMultipassLighting(shader, geom, rm);
                return;
            }
        }
        if (techDef.isUsingShaders()) {
            this.resetUniformsNotSetByCurrent(shader);
            r.setShader(shader);
        }
        r.renderMesh(geom.getMesh(), geom.getLodLevel(), 1);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.def.getAssetName(), "material_def", null);
        oc.write(this.additionalState, "render_state", null);
        oc.write(this.transparent, "is_transparent", false);
        oc.writeStringSavableMap(this.paramValues, "parameters", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.additionalState = (RenderState)ic.readSavable("render_state", null);
        this.transparent = ic.readBoolean("is_transparent", false);
        String defName = ic.readString("material_def", null);
        HashMap params = (HashMap)ic.readStringSavableMap("parameters", null);
        boolean enableVcolor = false;
        boolean separateTexCoord = false;
        boolean applyDefaultValues = false;
        boolean guessRenderStateApply = false;
        int ver = ic.getSavableVersion(Material.class);
        if (ver < 1) {
            applyDefaultValues = true;
        }
        if (ver < 2) {
            guessRenderStateApply = true;
        }
        if (im.getFormatVersion() == 0) {
            MatParam value;
            if (defName.equalsIgnoreCase("Common/MatDefs/Misc/VertexColor.j3md")) {
                enableVcolor = true;
                defName = "Common/MatDefs/Misc/Unshaded.j3md";
            } else if (defName.equalsIgnoreCase("Common/MatDefs/Misc/SimpleTextured.j3md") || defName.equalsIgnoreCase("Common/MatDefs/Misc/SolidColor.j3md")) {
                defName = "Common/MatDefs/Misc/Unshaded.j3md";
            } else if (defName.equalsIgnoreCase("Common/MatDefs/Misc/WireColor.j3md")) {
                this.getAdditionalRenderState().setWireframe(true);
                defName = "Common/MatDefs/Misc/Unshaded.j3md";
            } else if (defName.equalsIgnoreCase("Common/MatDefs/Misc/Unshaded.j3md") && (value = (MatParam)params.get("SeperateTexCoord")) != null && ((Boolean)value.getValue()).booleanValue()) {
                params.remove("SeperateTexCoord");
                separateTexCoord = true;
            }
            assert (applyDefaultValues && guessRenderStateApply);
        }
        this.def = (MaterialDef)im.getAssetManager().loadAsset(new AssetKey(defName));
        this.paramValues = new ListMap();
        for (Map.Entry entry : params.entrySet()) {
            MatParam param = (MatParam)entry.getValue();
            if (param instanceof MatParamTexture) {
                MatParamTexture texVal = (MatParamTexture)param;
                if (this.nextTexUnit < texVal.getUnit() + 1) {
                    this.nextTexUnit = texVal.getUnit() + 1;
                }
                if (texVal.getTextureValue() == null || texVal.getTextureValue().getImage() == null) continue;
            }
            param.setName(this.checkSetParam(param.getVarType(), param.getName()));
            this.paramValues.put(param.getName(), param);
        }
        if (applyDefaultValues) {
            for (MatParam param : this.def.getMaterialParams()) {
                if (param.getValue() == null || this.paramValues.get(param.getName()) != null) continue;
                this.setParam(param.getPrefixedName(), param.getVarType(), param.getValue());
            }
        }
        if (guessRenderStateApply && this.additionalState != null) {
            this.additionalState.applyPolyOffset = this.additionalState.offsetEnabled;
            this.additionalState.applyAlphaFallOff = this.additionalState.alphaTest;
            this.additionalState.applyAlphaTest = this.additionalState.alphaTest;
            this.additionalState.applyBlendMode = this.additionalState.blendMode != RenderState.BlendMode.Off;
            this.additionalState.applyColorWrite = !this.additionalState.colorWrite;
            this.additionalState.applyCullMode = this.additionalState.cullMode != RenderState.FaceCullMode.Back;
            this.additionalState.applyDepthTest = !this.additionalState.depthTest;
            this.additionalState.applyDepthWrite = !this.additionalState.depthWrite;
            this.additionalState.applyPointSprite = this.additionalState.pointSprite;
            this.additionalState.applyStencilTest = this.additionalState.stencilTest;
            this.additionalState.applyWireFrame = this.additionalState.wireframe;
        }
        if (enableVcolor) {
            this.setBoolean("VertexColor", true);
        }
        if (separateTexCoord) {
            this.setBoolean("SeparateTexCoord", true);
        }
    }

    void putTechnique(String name, Technique tech) {
        this.techniques.put(name, tech);
        this.techniqueArray = null;
    }

    void setTechniqueArray() {
        this.techniqueArray = this.techniques.values().toArray(new Technique[this.techniques.size()]);
    }

    static {
        depthOnly.setDepthTest(true);
        depthOnly.setDepthWrite(true);
        depthOnly.setFaceCullMode(RenderState.FaceCullMode.Back);
        depthOnly.setColorWrite(false);
        additiveLight.setBlendMode(RenderState.BlendMode.AlphaAdditive);
        additiveLight.setDepthWrite(false);
    }
}

