/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.TextureKey;
import com.jme3.material.FixedFuncBinding;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.blockparser.BlockLanguageParser;
import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J3MLoader
implements AssetLoader {
    private AssetManager owner;
    private AssetKey key;
    private MaterialDef materialDef;
    private Material material;
    private TechniqueDef technique;
    private RenderState renderState;
    private String shaderLang;
    private String vertName;
    private String fragName;
    private static final String whitespacePattern = "\\p{javaWhitespace}+";

    private void throwIfNequal(String expected, String got) throws IOException {
        if (expected == null) {
            throw new IOException("Expected a statement, got '" + got + "'!");
        }
        if (!expected.equals(got)) {
            throw new IOException("Expected '" + expected + "', got '" + got + "'!");
        }
    }

    private Image createColorTexture(ColorRGBA color) {
        if (color.getAlpha() == 1.0f) {
            ByteBuffer data = BufferUtils.createByteBuffer(3);
            byte[] bytes = color.asBytesRGBA();
            data.put(bytes[0]).put(bytes[1]).put(bytes[2]);
            data.flip();
            return new Image(Image.Format.RGB8, 1, 1, data);
        }
        ByteBuffer data = BufferUtils.createByteBuffer(4);
        data.putInt(color.asIntRGBA());
        data.flip();
        return new Image(Image.Format.RGBA8, 1, 1, data);
    }

    private void readShaderStatement(String statement) throws IOException {
        String[] split = statement.split(":");
        if (split.length != 2) {
            throw new IOException("Shader statement syntax incorrect" + statement);
        }
        String[] typeAndLang = split[0].split(whitespacePattern);
        if (typeAndLang.length != 2) {
            throw new IOException("Shader statement syntax incorrect: " + statement);
        }
        this.shaderLang = typeAndLang[1];
        if (typeAndLang[0].equals("VertexShader")) {
            this.vertName = split[1].trim();
        } else if (typeAndLang[0].equals("FragmentShader")) {
            this.fragName = split[1].trim();
        }
    }

    private void readLightMode(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("LightMode statement syntax incorrect");
        }
        TechniqueDef.LightMode lm = TechniqueDef.LightMode.valueOf(split[1]);
        this.technique.setLightMode(lm);
    }

    private void readShadowMode(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("ShadowMode statement syntax incorrect");
        }
        TechniqueDef.ShadowMode sm = TechniqueDef.ShadowMode.valueOf(split[1]);
        this.technique.setShadowMode(sm);
    }

    private Object readValue(VarType type, String value) throws IOException {
        if (type.isTextureType()) {
            String texturePath = value.trim();
            boolean flipY = false;
            boolean repeat = false;
            if (texturePath.startsWith("Flip Repeat ")) {
                texturePath = texturePath.substring(12).trim();
                flipY = true;
                repeat = true;
            } else if (texturePath.startsWith("Flip ")) {
                texturePath = texturePath.substring(5).trim();
                flipY = true;
            } else if (texturePath.startsWith("Repeat ")) {
                texturePath = texturePath.substring(7).trim();
                repeat = true;
            }
            TextureKey key = new TextureKey(texturePath, flipY);
            key.setAsCube(type == VarType.TextureCubeMap);
            key.setGenerateMips(true);
            Texture tex = this.owner.loadTexture(key);
            if (tex != null && repeat) {
                tex.setWrap(Texture.WrapMode.Repeat);
            }
            return tex;
        }
        String[] split = value.trim().split(whitespacePattern);
        switch (type) {
            case Float: {
                if (split.length != 1) {
                    throw new IOException("Float value parameter must have 1 entry: " + value);
                }
                return Float.valueOf(Float.parseFloat(split[0]));
            }
            case Vector2: {
                if (split.length != 2) {
                    throw new IOException("Vector2 value parameter must have 2 entries: " + value);
                }
                return new Vector2f(Float.parseFloat(split[0]), Float.parseFloat(split[1]));
            }
            case Vector3: {
                if (split.length != 3) {
                    throw new IOException("Vector3 value parameter must have 3 entries: " + value);
                }
                return new Vector3f(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            }
            case Vector4: {
                if (split.length != 4) {
                    throw new IOException("Vector4 value parameter must have 4 entries: " + value);
                }
                return new ColorRGBA(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
            }
            case Int: {
                if (split.length != 1) {
                    throw new IOException("Int value parameter must have 1 entry: " + value);
                }
                return Integer.parseInt(split[0]);
            }
            case Boolean: {
                if (split.length != 1) {
                    throw new IOException("Boolean value parameter must have 1 entry: " + value);
                }
                return Boolean.parseBoolean(split[0]);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private void readParam(String statement) throws IOException {
        int startParen;
        String defaultVal = null;
        FixedFuncBinding ffBinding = null;
        String[] split = statement.split(":");
        if (split.length != 1) {
            if (split.length != 2) {
                throw new IOException("Parameter statement syntax incorrect");
            }
            statement = split[0].trim();
            defaultVal = split[1].trim();
        }
        if ((startParen = statement.indexOf("(")) != -1) {
            int endParen = statement.indexOf(")", startParen);
            String bindingStr = statement.substring(startParen + 1, endParen).trim();
            try {
                ffBinding = FixedFuncBinding.valueOf(bindingStr);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("FixedFuncBinding '" + split[1] + "' does not exist!");
            }
            statement = statement.substring(0, startParen);
        }
        if ((split = statement.split(whitespacePattern)).length != 2) {
            throw new IOException("Parameter statement syntax incorrect");
        }
        VarType type = split[0].equals("Color") ? VarType.Vector4 : VarType.valueOf(split[0]);
        String name = split[1];
        Object defaultValObj = null;
        if (defaultVal != null) {
            defaultValObj = this.readValue(type, defaultVal);
        }
        this.materialDef.addMaterialParam(type, name, defaultValObj, ffBinding);
    }

    private void readValueParam(String statement) throws IOException {
        String[] split = statement.split(":", 2);
        if (split.length != 2) {
            throw new IOException("Value parameter statement syntax incorrect");
        }
        String name = split[0].trim();
        MatParam p = this.material.getMaterialDef().getMaterialParam(name);
        if (p == null) {
            throw new IOException("The material parameter: " + name + " is undefined.");
        }
        Object valueObj = this.readValue(p.getVarType(), split[1]);
        if (p.getVarType().isTextureType()) {
            this.material.setTextureParam(name, p.getVarType(), (Texture)valueObj);
        } else {
            this.material.setParam(name, p.getVarType(), valueObj);
        }
    }

    private void readMaterialParams(List<Statement> paramsList) throws IOException {
        for (Statement statement : paramsList) {
            this.readParam(statement.getLine());
        }
    }

    private void readExtendingMaterialParams(List<Statement> paramsList) throws IOException {
        for (Statement statement : paramsList) {
            this.readValueParam(statement.getLine());
        }
    }

    private void readWorldParams(List<Statement> worldParams) throws IOException {
        for (Statement statement : worldParams) {
            this.technique.addWorldParam(statement.getLine());
        }
    }

    private boolean parseBoolean(String word) {
        return word != null && word.equals("On");
    }

    private void readRenderStateStatement(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split[0].equals("Wireframe")) {
            this.renderState.setWireframe(this.parseBoolean(split[1]));
        } else if (split[0].equals("FaceCull")) {
            this.renderState.setFaceCullMode(RenderState.FaceCullMode.valueOf(split[1]));
        } else if (split[0].equals("DepthWrite")) {
            this.renderState.setDepthWrite(this.parseBoolean(split[1]));
        } else if (split[0].equals("DepthTest")) {
            this.renderState.setDepthTest(this.parseBoolean(split[1]));
        } else if (split[0].equals("Blend")) {
            this.renderState.setBlendMode(RenderState.BlendMode.valueOf(split[1]));
        } else if (split[0].equals("AlphaTestFalloff")) {
            this.renderState.setAlphaTest(true);
            this.renderState.setAlphaFallOff(Float.parseFloat(split[1]));
        } else if (split[0].equals("PolyOffset")) {
            float factor = Float.parseFloat(split[1]);
            float units = Float.parseFloat(split[2]);
            this.renderState.setPolyOffset(factor, units);
        } else if (split[0].equals("ColorWrite")) {
            this.renderState.setColorWrite(this.parseBoolean(split[1]));
        } else if (split[0].equals("PointSprite")) {
            this.renderState.setPointSprite(this.parseBoolean(split[1]));
        } else {
            this.throwIfNequal(null, split[0]);
        }
    }

    private void readAdditionalRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = this.material.getAdditionalRenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement.getLine());
        }
        this.renderState = null;
    }

    private void readRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = new RenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement.getLine());
        }
        this.technique.setRenderState(this.renderState);
        this.renderState = null;
    }

    private void readDefine(String statement) throws IOException {
        String[] split = statement.split(":");
        if (split.length == 1) {
            this.technique.addShaderPresetDefine(split[0].trim(), VarType.Boolean, true);
        } else if (split.length == 2) {
            this.technique.addShaderParamDefine(split[1].trim(), split[0].trim());
        } else {
            throw new IOException("Define syntax incorrect");
        }
    }

    private void readDefines(List<Statement> defineList) throws IOException {
        for (Statement statement : defineList) {
            this.readDefine(statement.getLine());
        }
    }

    private void readTechniqueStatement(Statement statement) throws IOException {
        String[] split = statement.getLine().split("[ \\{]");
        if (split[0].equals("VertexShader") || split[0].equals("FragmentShader")) {
            this.readShaderStatement(statement.getLine());
        } else if (split[0].equals("LightMode")) {
            this.readLightMode(statement.getLine());
        } else if (split[0].equals("ShadowMode")) {
            this.readShadowMode(statement.getLine());
        } else if (split[0].equals("WorldParameters")) {
            this.readWorldParams(statement.getContents());
        } else if (split[0].equals("RenderState")) {
            this.readRenderState(statement.getContents());
        } else if (split[0].equals("Defines")) {
            this.readDefines(statement.getContents());
        } else {
            this.throwIfNequal(null, split[0]);
        }
    }

    private void readTransparentStatement(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("Transparent statement syntax incorrect");
        }
        this.material.setTransparent(this.parseBoolean(split[1]));
    }

    private void readTechnique(Statement techStat) throws IOException {
        String[] split = techStat.getLine().split(whitespacePattern);
        if (split.length == 1) {
            this.technique = new TechniqueDef(null);
        } else if (split.length == 2) {
            this.technique = new TechniqueDef(split[1]);
        } else {
            throw new IOException("Technique statement syntax incorrect");
        }
        for (Statement statement : techStat.getContents()) {
            this.readTechniqueStatement(statement);
        }
        if (this.vertName != null && this.fragName != null) {
            this.technique.setShaderFile(this.vertName, this.fragName, this.shaderLang);
        }
        this.materialDef.addTechniqueDef(this.technique);
        this.technique = null;
        this.vertName = null;
        this.fragName = null;
        this.shaderLang = null;
    }

    private void loadFromRoot(List<Statement> roots) throws IOException {
        if (roots.size() == 2) {
            Statement exception = roots.get(0);
            String line = exception.getLine();
            if (line.startsWith("Exception")) {
                throw new AssetLoadException(line.substring("Exception ".length()));
            }
            throw new IOException("In multiroot material, expected first statement to be 'Exception'");
        }
        if (roots.size() != 1) {
            throw new IOException("Too many roots in J3M/J3MD file");
        }
        boolean extending = false;
        Statement materialStat = roots.get(0);
        String materialName = materialStat.getLine();
        if (materialName.startsWith("MaterialDef")) {
            materialName = materialName.substring("MaterialDef ".length()).trim();
            extending = false;
        } else if (materialName.startsWith("Material")) {
            materialName = materialName.substring("Material ".length()).trim();
            extending = true;
        } else {
            throw new IOException("Specified file is not a Material file");
        }
        String[] split = materialName.split(":", 2);
        if (materialName.equals("")) {
            throw new IOException("Material name cannot be empty");
        }
        if (split.length == 2) {
            if (!extending) {
                throw new IOException("Must use 'Material' when extending.");
            }
            String extendedMat = split[1].trim();
            MaterialDef def = (MaterialDef)this.owner.loadAsset(new AssetKey(extendedMat));
            if (def == null) {
                throw new IOException("Extended material " + extendedMat + " cannot be found.");
            }
            this.material = new Material(def);
            this.material.setKey(this.key);
        } else if (split.length == 1) {
            if (extending) {
                throw new IOException("Expected ':', got '{'");
            }
            this.materialDef = new MaterialDef(this.owner, materialName);
            this.materialDef.setAssetName(this.key.getName());
        } else {
            throw new IOException("Cannot use colon in material name/path");
        }
        for (Statement statement : materialStat.getContents()) {
            split = statement.getLine().split("[ \\{]");
            String statType = split[0];
            if (extending) {
                if (statType.equals("MaterialParameters")) {
                    this.readExtendingMaterialParams(statement.getContents());
                    continue;
                }
                if (statType.equals("AdditionalRenderState")) {
                    this.readAdditionalRenderState(statement.getContents());
                    continue;
                }
                if (!statType.equals("Transparent")) continue;
                this.readTransparentStatement(statement.getLine());
                continue;
            }
            if (statType.equals("Technique")) {
                this.readTechnique(statement);
                continue;
            }
            if (statType.equals("MaterialParameters")) {
                this.readMaterialParams(statement.getContents());
                continue;
            }
            throw new IOException("Expected material statement, got '" + statType + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info) throws IOException {
        this.owner = info.getManager();
        InputStream in = info.openStream();
        try {
            this.key = info.getKey();
            this.loadFromRoot(BlockLanguageParser.parse(in));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (this.material != null) {
            if (!(info.getKey() instanceof MaterialKey)) {
                throw new IOException("Material instances must be loaded via MaterialKey");
            }
            return this.material;
        }
        return this.materialDef;
    }
}

